// fl_x.H

// This file contains public parts of Fl that depend on Xlib, and
// undocumented variables that it may be useful to refer to.  You
// should include this file if (and ONLY if) you need to call Xlib directly.

#ifndef Fl_X_H
#define Fl_X_H

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

void fl_open_display();
void fl_close_display();

extern Display *fl_display;
extern int fl_screen;
extern XVisualInfo *fl_visual;
extern Colormap fl_colormap;
extern GC fl_gc;
extern Window fl_window;
extern XEvent fl_xevent;

unsigned long fl_xpixel(uchar i);
unsigned long fl_xpixel(uchar r, uchar g, uchar b);

////////////////////////////////////////////////////////////////
// Undocumented and may change in future versions:

// mapping from fl colormap to x pixel numbers:
struct Fl_XMap {
  char mapped;	// true when XAllocColor done
  uchar r,g,b;	// actual color used by X
  ulong pixel;	// the pixel to use
};
extern Fl_XMap fl_xmap[256];

// mask & shifts to produce xcolor for truecolor visuals:
extern uchar fl_redmask, fl_greenmask, fl_bluemask;
extern int fl_redshift, fl_greenshift, fl_blueshift, fl_extrashift;

class Fl_Object;
class Fl_Window;
extern uchar fl_overlay; // changes how fl_xpixel works
extern uchar fl_rgbmode; // changes how fl_xpixel works (nyi)
extern char fl_override_redirect; // hack into Fl_Window::make_xid()
extern int fl_background_pixel;  // hack into Fl_Window::make_xid()
unsigned long fl_alloc_color(Colormap c, uchar i); // copy fl_color into map
extern Fl_Window *fl_xfocus;	// which window X thinks has focus
extern Fl_Window *fl_xmousewin; // which window X thinks has FL_ENTER
void fl_fix_focus();	// send focus/enter/exit events after changing fl_x*
extern Fl_Window *fl_selection_window; // window X thinks selection belongs to
extern Fl_Object *fl_selection_requestor; // object doing request_paste()
extern Fl_Window *fl_resize_bug_fix; // prevents echoing of resize X events
extern Atom fl_wm_delete_window; // atoms created when display opened
extern Atom fl__wm_quit_app;
extern Atom fl_wm_protocols;
extern Atom fl__motif_wm_hints;

#endif
