// This is an additional header file for "DDForms", which was our internal
// enhancement of Forms.  This defines the precursor of the Fl_Menu class.
//
// Unfortunately it defined the callbacks as taking a long rather
// than a void* argument, requiring some dubious casts to emulate it:

#include "Fl_Menu_Bar.H"

struct MenuEntry {
    const char *text;	/*initial character indicates "type", 0 = end of menu*/
    const char *bind;	/* key binding in forms format (#x, etc) */
    void (*cb)(FL_OBJECT *,long);	/* callback */
    long data;		/* value for callback */
    int flags;		/* see below for flags */
};

#define CHECKED FL_PUP_CHECK
#define UNCHECKED FL_PUP_BOX
#define DISABLED FL_PUP_GREY

/* Turn a box into a menu bar: */
inline void MenuBar(Fl_Object *o,MenuEntry *m) {
    Fl_Menu_Bar *mb = new Fl_Menu_Bar(o->x(),o->y(),o->w(),o->h());
    mb->menu((Fl_Menu*)m);
    mb->box(0);
    Fl_Group *g = (Fl_Group *)(o->parent());
    int i = g->find(*o);
    g->insert(*mb, i<g->children()-1 ? g->child(i+1) : 0);
}

/* advance to the Nth item in menu, skipping submenus: */
inline MenuEntry *MenuGetEntry(MenuEntry *m,int i) {
    return (MenuEntry*)(((Fl_Menu*)m)->next(i));
}

/* Init the shortcuts for an object with a popup menu: */
inline void MenuSetShortcuts(FL_OBJECT *, MenuEntry *) {}

inline void MenuAdd(
    MenuEntry m[],
    int, /* number of entries in menutable, ignored here */
    const char *text,
    const char *bind,
    void (*cb)(FL_OBJECT *,long),
    long data,
    int flags) {
    ((Fl_Menu*)m)->add(text,bind,(Fl_Callback*)cb,(void *)data,flags);
}

inline MenuEntry *MenuPopup(FL_OBJECT *o,const char *title,MenuEntry *m,float x,float y) {
    const Fl_Menu *v = ((Fl_Menu*)m)->popup(x,y,title);
    if (v && v->callback) v->callback(o,v->argument);
    return (MenuEntry *)v;
}

inline MenuEntry *MenuHandleShortcut(FL_OBJECT *o,MenuEntry *m,char) {
    const Fl_Menu *v = ((Fl_Menu*)m)->test_shortcut();
    if (v && v->callback) v->callback(o,v->argument);
    return (MenuEntry *)v;
}
