// gl_draw.H

// "missing" OpenGL functions, and
// gl_start() and gl_finish() to allow OpenGL to be used in any window

#ifndef gl_draw_H
#define gl_draw_H

#include "Enumerations.H"  // for the color names
#include <GL/gl.h>

void gl_start();
void gl_finish();

void gl_color(uchar);

void gl_rect(int x,int y,int w,int h);
inline void gl_rectf(int x,int y,int w,int h) {glRecti(x,y,x+w,y+h);}

void gl_arc(float x, float y, float w, float h, int start, int end);
void gl_arc(float x, float y, float r, int start, int end);
void gl_circle(float x, float y, float w, float h);
void gl_circle(float x, float y, float r);

void gl_font(uchar fontid, int size);
int  gl_height();
int  gl_descent();
float gl_width(const char *);
float gl_width(const char *, int n);
float gl_width(uchar);

void gl_draw(const char *);
void gl_draw(const char *, int n);
void gl_draw(const char *, int x, int y);
void gl_draw(const char *, int n, int x, int y);
void gl_draw(const char *, int x, int y, int w, int h, uchar align);

void gl_draw_image(const uchar *, int x, int y, int w, int h,int d=3,int ld=0);

#endif
