// forms.h

// Include file for emulating the original Mark Overmars
// Forms library.  Based on version 0.86, 3/22/97
// Warning: emulation is in no way 100%!!

#ifndef __FORMS_H__
#define __FORMS_H__

#include "Fl.H"
#include "Fl_Group.H"
#include "Fl_Window.H"
#include "fl_draw.H"
#include "Fl_Menu.H"

typedef Fl_Object FL_OBJECT;
typedef Fl_Window FL_FORM;

////////////////////////////////////////////////////////////////
// Random constants & symbols defined by forms.h file:

#ifndef NULL
#define NULL 0
#endif
#ifndef FALSE
#define FALSE 0
#define TRUE 1
#endif

enum {
  FL_ON			= 1,
  FL_OK			= 1,
  FL_VALID		= 1,
  FL_PREEMPT		= 1,
  FL_AUTO		= 2,
  FL_WHEN_NEEDED	= FL_AUTO,
  FL_OFF		= 0,
  FL_NONE		= 0,
  FL_CANCEL		= 0,
  FL_INVALID		= 0,
  FL_IGNORE		= -1,
//FL_CLOSE		= -2,

  FL_PATH_MAX		= 1024,

  FL_LCOL		= FL_BLACK,
  FL_COL1		= FL_GRAY,
  FL_MCOL		= FL_LIGHT1,
  FL_LEFT_BCOL		= FL_LIGHT3, // 53 is better match
  FL_TOP_BCOL		= FL_LIGHT2, // 51
  FL_BOTTOM_BCOL	= FL_DARK2,  // 40
  FL_RIGHT_BCOL		= FL_DARK3,  // 36
  FL_INACTIVE		= FL_INACTIVE_COLOR,
  FL_INACTIVE_COL	= FL_INACTIVE_COLOR,
  FL_FREE_COL1		= FL_FREE_COLOR,
  FL_FREE_COL2		= FL_FREE_COLOR+1,
  FL_FREE_COL3		= FL_FREE_COLOR+2,
  FL_FREE_COL4		= FL_FREE_COLOR+3,
  FL_FREE_COL5		= FL_FREE_COLOR+4,
  FL_FREE_COL6		= FL_FREE_COLOR+5,
  FL_FREE_COL7		= FL_FREE_COLOR+6,
  FL_FREE_COL8		= FL_FREE_COLOR+7,
  FL_FREE_COL9		= FL_FREE_COLOR+8,
  FL_FREE_COL10		= FL_FREE_COLOR+9,
  FL_FREE_COL11		= FL_FREE_COLOR+10,
  FL_FREE_COL12		= FL_FREE_COLOR+11,
  FL_FREE_COL13		= FL_FREE_COLOR+12,
  FL_FREE_COL14		= FL_FREE_COLOR+13,
  FL_FREE_COL15		= FL_FREE_COLOR+14,
  FL_FREE_COL16		= FL_FREE_COLOR+15,
  FL_TOMATO		= 131,
  FL_INDIANRED		= 164,
  FL_SLATEBLUE		= 195,
  FL_DARKGOLD		= 84,
  FL_PALEGREEN		= 157,
  FL_ORCHID		= 203,
  FL_DARKCYAN		= 189,
  FL_DARKTOMATO		= 113,
  FL_WHEAT		= 174,

  FL_ALIGN_TOP_LEFT	= FL_ALIGN_TOP | FL_ALIGN_LEFT,
  FL_ALIGN_TOP_RIGHT	= FL_ALIGN_TOP | FL_ALIGN_RIGHT,
  FL_ALIGN_BOTTOM_LEFT	= FL_ALIGN_BOTTOM | FL_ALIGN_LEFT,
  FL_ALIGN_BOTTOM_RIGHT	= FL_ALIGN_BOTTOM | FL_ALIGN_RIGHT,
  FL_ALIGN_LEFT_TOP	= FL_ALIGN_TOP_LEFT,
  FL_ALIGN_RIGHT_TOP	= FL_ALIGN_TOP_RIGHT,
  FL_ALIGN_LEFT_BOTTOM	= FL_ALIGN_BOTTOM_LEFT,
  FL_ALIGN_RIGHT_BOTTOM	= FL_ALIGN_BOTTOM_RIGHT,
  FL_ALIGN_BESIDE	= FL_ALIGN_INSIDE,

  FL_PUP_TOGGLE    	= FL_PUP_BOX,
  FL_PUP_INACTIVE  	= FL_PUP_GREY,

  FL_NO_FRAME		= FL_NO_BOX,
#define FL_ROUNDED3D_UPBOX 	FL_ROUND_UP_BOX
#define FL_ROUNDED3D_DOWNBOX	FL_ROUND_DOWN_BOX
#define FL_OVAL3D_UPBOX		FL_ROUND_UP_BOX
#define FL_OVAL3D_DOWNBOX	FL_ROUND_DOWN_BOX

  FL_MBUTTON1		= 1,
  FL_LEFT_MOUSE		= 1,
  FL_LEFTMOUSE		= 1,
  FL_MBUTTON2		= 2,
  FL_MIDDLE_MOUSE	= 2,
  FL_MIDDLEMOUSE	= 2,
  FL_MBUTTON3		= 3,
  FL_RIGHT_MOUSE	= 3,
  FL_RIGHTMOUSE		= 3,
  FL_MBUTTON4		= 4,
  FL_MBUTTON5		= 5,

  FL_INVALID_STYLE 	= 255,
  FL_NORMAL_STYLE	= FL_HELVETICA,
  FL_BOLD_STYLE		= FL_HELVETICA|FL_BOLD,
  FL_ITALIC_STYLE	= FL_HELVETICA|FL_ITALIC,
  FL_BOLDITALIC_STYLE	= FL_HELVETICA|FL_BOLD|FL_ITALIC,
  FL_FIXED_STYLE	= FL_COURIER,
  FL_FIXEDBOLD_STYLE	= FL_COURIER|FL_BOLD,
  FL_FIXEDITALIC_STYLE	= FL_COURIER|FL_ITALIC,
  FL_FIXEDBOLDITALIC_STYLE = FL_COURIER|FL_BOLD|FL_ITALIC,
  FL_TIMES_STYLE	= FL_TIMES,
  FL_TIMESBOLD_STYLE	= FL_TIMES|FL_BOLD,
  FL_TIMESITALIC_STYLE	= FL_TIMES|FL_ITALIC,
  FL_TIMESBOLDITALIC_STYLE = FL_TIMES|FL_BOLD|FL_ITALIC,

// hacks to change the labeltype() when passed to fl_set_object_lstyle():
#define FL_SHADOW_STYLE		(FL_SHADOW_LABEL<<8)
#define FL_ENGRAVED_STYLE	(FL_ENGRAVED_LABEL<<8)
#define FL_EMBOSSED_STYLE	(FL_EMBOSSED_LABEL<<0)

// size values are different from XForms, match older Forms:
  FL_TINY_SIZE		= 8,
  FL_SMALL_SIZE		= 11, // 10
//FL_NORMAL_SIZE	= 14, // 12
  FL_MEDIUM_SIZE	= 18, // 14
  FL_LARGE_SIZE		= 24, // 18
  FL_HUGE_SIZE		= 32, // 24
  FL_DEFAULT_SIZE	= FL_SMALL_SIZE,
  FL_TINY_FONT		= FL_TINY_SIZE,
  FL_SMALL_FONT		= FL_SMALL_SIZE,
  FL_NORMAL_FONT	= FL_NORMAL_SIZE,
  FL_MEDIUM_FONT	= FL_MEDIUM_SIZE,
  FL_LARGE_FONT		= FL_LARGE_SIZE,
  FL_HUGE_FONT		= FL_HUGE_SIZE,
  FL_NORMAL_FONT1	= FL_SMALL_FONT,
  FL_NORMAL_FONT2	= FL_NORMAL_FONT,
  FL_DEFAULT_FONT	= FL_SMALL_FONT,

  FL_RETURN_END_CHANGED = 0,
  FL_RETURN_CHANGED	= 1,
  FL_RETURN_END		= 2,
  FL_RETURN_ALWAYS	= 3,

  FL_BOUND_WIDTH	= 3

};

typedef int FL_Coord;
typedef unsigned long FL_COLOR; // FL uses a char

////////////////////////////////////////////////////////////////
// Fl interaction:

#define FL_CMD_OPT void
extern void fl_initialize(int *, char *[], const char *, FL_CMD_OPT *, int);
inline void fl_finish() {}

typedef void (*FL_IO_CALLBACK) (int, void *);
inline void fl_add_io_callback(int fd, short w, FL_IO_CALLBACK cb, void* v) {
  Fl::add_fd(fd,w,cb,v);}
inline void fl_remove_io_callback(int fd, short, FL_IO_CALLBACK) {
  Fl::remove_fd(fd);} // removes all the callbacks!

// type of callback is different and no "id" number is returned:
inline void fl_add_timeout(long msec, void (*cb)(void *), void *v) {
  Fl::add_timeout(msec*.001, cb, v);}
inline void fl_remove_timeout(int) {}

// type of callback is different!
inline void fl_set_idle_callback(void (*cb)()) {Fl::set_idle(cb);}

Fl_Object *fl_do_forms(void);
Fl_Object *fl_check_forms();
inline Fl_Object *fl_do_only_forms(void) {return fl_do_forms();}
inline Fl_Object *fl_check_only_forms(void) {return fl_check_forms();}

// because of new redraw behavior, these are no-ops:
inline void fl_freeze_object(Fl_Object *) {}
inline void fl_unfreeze_object(Fl_Object *) {}
inline void fl_freeze_form(Fl_Window *) {}
inline void fl_unfreeze_form(Fl_Window *) {}
inline void fl_freeze_all_forms() {}
inline void fl_unfreeze_all_forms() {}

inline void fl_set_focus_object(Fl_Window *, Fl_Object *o) {Fl::focus(o);}
inline void fl_reset_focus_object(Fl_Object *o) {Fl::focus(o);}
#define fl_set_object_focus fl_set_focus_object

// void fl_set_form_atclose(Fl_Window*w,int (*cb)(Fl_Window*,void*),void* v)
// void fl_set_atclose(int (*cb)(Fl_Window*,void*),void*)
// fl_set_form_atactivate/atdeactivate not implemented!

////////////////////////////////////////////////////////////////
// Fl_Object:

inline void fl_set_object_boxtype(Fl_Object* o, uchar a) {o->box(a);}
inline void fl_set_object_lsize(Fl_Object* o,int s) {o->labelsize(s);}
inline void fl_set_object_lstyle(Fl_Object* o,int a) {
  o->labelfont(a); o->labeltype(a>>8);}
inline void fl_set_object_lcol(Fl_Object* o, int a) {o->labelcolor(a);}
#define fl_set_object_lcolor  fl_set_object_lcol
inline void fl_set_object_lalign(Fl_Object* o, int a) {o->align(a);}
#define fl_set_object_align fl_set_object_lalign
inline void fl_set_object_color(Fl_Object* o, int a, int b) {o->color(a,b);}
inline void fl_set_object_label(Fl_Object* o, const char *a) {o->label(a); o->redraw();}
inline void fl_set_object_position(Fl_Object*o,int x,int y) {o->position(x,y);}
inline void fl_set_object_size(Fl_Object* o, int w, int h) {o->size(w,h);}
inline void fl_set_object_geometry(Fl_Object *o,int x,int y,int w,int h) {o->resize(x,y,w,h);}

inline void fl_get_object_geometry(Fl_Object *o,int*x,int*y,int*w,int*h) {
  *x = o->x(); *y = o->y(); *w = o->w(); *h = o->h();}
inline void fl_get_object_position(Fl_Object *o,int*x,int*y) {
  *x = o->x(); *y = o->y();}

typedef void (*Forms_CB)(Fl_Object *, long);
inline void fl_set_object_callback(Fl_Object*o,Forms_CB c,long a) {o->callback(c,a);}
#define fl_set_call_back      fl_set_object_callback
inline void fl_call_object_callback(Fl_Object *o) {o->do_callback();}
inline void fl_trigger_object(Fl_Object *o) {o->do_callback();}
inline void fl_set_object_return(FL_OBJECT* o, int v) {
  o->when(v|FL_WHEN_RELEASE);}

inline void fl_redraw_object(Fl_Object *o) {o->redraw();}
inline void fl_show_object(Fl_Object *o) {o->show();}
inline void fl_hide_object(Fl_Object *o) {o->hide();}
inline void fl_free_object(Fl_Object *x) {delete x;}
inline void fl_delete_object(Fl_Object *o) {((Fl_Group*)(o->parent()))->remove(*o);}
inline void fl_activate_object(Fl_Object *o) {o->activate();}
inline void fl_deactivate_object(Fl_Object *o) {o->deactivate();}

inline void fl_add_object(Fl_Window *f, Fl_Object*x) {f->add(x);}
inline void fl_insert_object(Fl_Object *o, Fl_Object* b) {
    ((Fl_Group*)(b->parent()))->insert(*o,b);}

inline Fl_Window *FL_ObjWin(Fl_Object *o) {return o->window();}

////////////////////////////////////////////////////////////////
// things that appered in the demos a lot that I don't emulate, but
// I did not want to edit out of all the demos...

inline int fl_get_border_width() {return 3;}
inline void fl_set_border_width(int) {}
inline void fl_set_object_dblbuffer(Fl_Object *, int) {}
inline void fl_set_form_dblbuffer(Fl_Window *, int) {}

////////////////////////////////////////////////////////////////
// Fl_Window:

inline void fl_free_form(Fl_Window *x) {delete x;}
inline void fl_redraw_form(Fl_Window *f) {f->redraw();}

inline Fl_Window *fl_bgn_form(uchar b,int w,int h) {
  Fl_Window *g = new Fl_Window(w,h,0);
  g->box(b);
  g->begin();
  return g;
}
void fl_end_form();
inline void fl_addto_form(Fl_Window *f) {f->begin();}
inline Fl_Group *fl_bgn_group() {
  Fl_Group *g = new Fl_Group(0,0,0,0,0);
  g->begin();
  return g;
}
void fl_end_group();
inline void fl_addto_group(Fl_Object *o) {
  ((Fl_Group *)o)->begin();
}
#define resizebox _ddfdesign_kludge()

inline void fl_scale_form(Fl_Window *f, float x, float y) {
  f->resizable(f); f->size(int(f->w()*x),int(f->h()*y));}
inline void fl_set_form_position(Fl_Window *f,int x,int y) {f->position(x,y);}
inline void fl_set_form_size(Fl_Window *f, int w, int h) {f->size(w,h);}
inline void fl_set_form_geometry(Fl_Window *f,int x,int y,int w,int h) {
  f->resize(x,y,w,h);}
#define fl_set_initial_placement fl_set_form_geometry
inline void fl_adjust_form_size(Fl_Window *) {}

void fl_show_form(Fl_Window *f,int p,int b,const char *n);
enum {	// "p" argument values:
  FL_PLACE_FREE = 0,	// make resizable
  FL_PLACE_MOUSE = 1,	// mouse centered on form
  FL_PLACE_CENTER = 2,	// center of the screen
  FL_PLACE_POSITION = 4,// fixed position, resizable
  FL_PLACE_SIZE = 8,	// fixed size, normal FL behavior
  FL_PLACE_GEOMETRY =16,// fixed size and position
  FL_PLACE_ASPECT = 32,	// keep aspect ratio (ignored)
  FL_PLACE_FULLSCREEN=64,// fill screen
  FL_PLACE_HOTSPOT = 128,// enables hotspot
  FL_PLACE_ICONIC = 256,// iconic (ignored)
  FL_FREE_SIZE=(1<<14),	// force resizable
  FL_FIX_SIZE =(1<<15)	// force off resizable
};
#define FL_PLACE_FREE_CENTER (FL_PLACE_CENTER|FL_FREE_SIZE)
#define FL_PLACE_CENTERFREE  (FL_PLACE_CENTER|FL_FREE_SIZE)
enum {	// "b" arguement values:
  FL_NOBORDER = 0,
  FL_FULLBORDER,
  FL_TRANSIENT,
//FL_MODAL = (1<<8)	// not implemented yet in Forms
};
inline void fl_set_form_hotspot(Fl_Window *w,int x,int y) {w->hotspot(x,y);}
inline void fl_set_form_hotobject(Fl_Window *w, Fl_Object *o) {w->hotspot(o);}
extern char fl_flip;	// in forms.C
inline void fl_flip_yorigin() {fl_flip = 1;}

#define fl_prepare_form_window fl_show_form
inline void fl_show_form_window(Fl_Window *) {}

inline void fl_raise_form(Fl_Window *f) {f->show();}

inline void fl_hide_form(Fl_Window *f) {f->hide();}
inline void fl_pop_form(Fl_Window *f) {f->show();}

extern char fl_modal_next; // in forms.C
inline void fl_activate_all_forms() {}
inline void fl_deactivate_all_forms() {fl_modal_next = 1;}
inline void fl_deactivate_form(Fl_Window*w) {w->deactivate();}
inline void fl_activate_form(Fl_Window*w) {w->activate();}

inline void fl_set_form_title(Fl_Window *f, const char *s) {f->label(s);}
inline void fl_title_form(Fl_Window *f, const char *s) {f->label(s);}

typedef void (*Forms_FormCB)(Fl_Object *);
inline void fl_set_form_callback(Fl_Window*f,Forms_FormCB c) {f->callback(c);}
#define fl_set_form_call_back fl_set_form_callback

inline void fl_init() {}
void fl_set_graphics_mode(int,int);

inline int fl_form_is_visible(Fl_Window *f) {return f->visible();}

inline int fl_mouse_button() {return Fl::event_button();}
#define fl_mousebutton fl_mouse_button

#define fl_free       free
#define fl_malloc     malloc
#define fl_calloc     calloc
#define fl_realloc    realloc

////////////////////////////////////////////////////////////////
// Drawing functions.  Only usable inside an Fl_Free object?

inline void fl_drw_box(uchar b,int x,int y,int w,int h,int bgc,int=3) {
    fl_draw_box(b,x,y,w,h,bgc);}
inline void fl_drw_frame(uchar b,int x,int y,int w,int h,int bgc,int=3) {
    fl_draw_box(b,x,y,w,h,bgc);}

inline void fl_drw_text(uchar align, int x, int y, int w, int h,
		  uchar fgcolor, int size, uchar style,
		  const char *s) {
  fl_font(style,size);
  fl_color(fgcolor);
  fl_draw(s,x,y,w,h,align);
}

// this does not work except for CENTER...
inline void fl_drw_text_beside(uchar align, int x, int y, int w, int h,
		  uchar fgcolor, int size, uchar style,
		  const char *s) {
  fl_font(style,size);
  fl_color(fgcolor);
  fl_draw(s,x,y,w,h,align);
}

inline void fl_set_font_name(int n,const char *s) {Fl::set_font(n,s);}

inline void fl_mapcolor(uchar c, uchar r, uchar g, uchar b) {Fl::set_color(c,r,g,b);}

#define fl_set_clipping(x,y,w,h) fl_clip(x,y,w,h)
#define fl_unset_clipping() fl_pop_clip()

////////////////////////////////////////////////////////////////
// Forms classes:

inline Fl_Object *fl_add_new(Fl_Object *p) {return p;}
inline Fl_Object *fl_add_new(uchar t,Fl_Object *p) {p->type(t); return p;}

#define forms_constructor(type,name) \
inline type *name(uchar t,int x,int y,int w,int h,const char *l) { \
 return (type *)(fl_add_new(t, new type(x,y,w,h,l)));}
#define forms_constructort(type,name) \
inline type *name(uchar t,int x,int y,int w,int h,const char *l) { \
 return (type *)(fl_add_new(new type(t,x,y,w,h,l)));}

#include "Fl_FormsBitmap.H"
#define FL_NORMAL_BITMAP	0
forms_constructort(Fl_FormsBitmap, fl_add_bitmap)
inline void fl_set_bitmap_data(Fl_Object *o, int w, int h, const uchar *b) {
    ((Fl_FormsBitmap*)o)->set(w,h,b);
}

#include "Fl_FormsPixmap.H"
#define FL_NORMAL_PIXMAP	0
forms_constructort(Fl_FormsPixmap, fl_add_pixmap)
inline void fl_set_pixmap_data(Fl_Object *o, char * const *b) {
    ((Fl_FormsPixmap*)o)->set(b);
}
//inline void fl_set_pixmap_file(FL_OBJECT *, const char *);
inline void fl_set_pixmap_align(Fl_Object *o, int a, int, int) {o->align(a);}
//inline void fl_set_pixmap_colorcloseness(int, int, int);

#include "Fl_Box.H"
forms_constructort(Fl_Box,fl_add_box)

#include "Fl_Browser.H"
forms_constructor(Fl_Browser, fl_add_browser)

inline void fl_clear_browser(FL_OBJECT *o) {
    ((Fl_Browser*)o)->clear();}
inline void fl_add_browser_line(FL_OBJECT *o, const char *s) {
    ((Fl_Browser*)o)->add(s);}
inline void fl_addto_browser(FL_OBJECT *o, const char *s) {
    ((Fl_Browser*)o)->add(s);} /* should also scroll to bottom */
//inline void fl_addto_browser_chars(FL_OBJECT *, const char *)
//#define fl_append_browser fl_addto_browser_chars
inline void fl_insert_browser_line(FL_OBJECT *o, int n, const char *s) {
    ((Fl_Browser*)o)->insert(n,s);}
inline void fl_delete_browser_line(FL_OBJECT *o, int n) {
    ((Fl_Browser*)o)->remove(n);}
inline void fl_replace_browser_line(FL_OBJECT *o, int n, const char *s) {
    ((Fl_Browser*)o)->replace(n,s);}
inline char *fl_get_browser_line(FL_OBJECT *o, int n) {
    return (char *)(((Fl_Browser*)o)->text(n));}
inline int fl_load_browser(FL_OBJECT *o, const char *f) {
    return ((Fl_Browser*)o)->load(f);}
inline void fl_select_browser_line(FL_OBJECT *o, int n) {
    ((Fl_Browser*)o)->select(n,1);}
inline void fl_deselect_browser_line(FL_OBJECT *o, int n) {
    ((Fl_Browser*)o)->select(n,0);}
inline void fl_deselect_browser(FL_OBJECT *o) {
    ((Fl_Browser*)o)->deselect();}
inline int fl_isselected_browser_line(FL_OBJECT *o, int n) {
    return ((Fl_Browser*)o)->selected(n);}
inline int fl_get_browser_topline(FL_OBJECT *o) {
    return ((Fl_Browser*)o)->topline();}
inline int fl_get_browser(FL_OBJECT *o) {
    return ((Fl_Browser*)o)->value();}
inline int fl_get_browser_maxline(FL_OBJECT *o) {
    return ((Fl_Browser*)o)->size();}
//linline int fl_get_browser_screenlines(FL_OBJECT *);
inline void fl_set_browser_topline(FL_OBJECT *o, int n) {
    ((Fl_Browser*)o)->topline(n);}
inline void fl_set_browser_fontsize(FL_OBJECT *o, int s) {
    ((Fl_Browser*)o)->textsize(s);}
inline void fl_set_browser_fontstyle(FL_OBJECT *o, int s) {
    ((Fl_Browser*)o)->textfont(s);}
inline void fl_set_browser_specialkey(FL_OBJECT *o, char c) {
    ((Fl_Browser*)o)->specialkey(c);}
//inline void fl_set_browser_vscrollbar(FL_OBJECT *, int);
//inline void fl_set_browser_hscrollbar(FL_OBJECT *, int);
//inline void fl_set_browser_leftslider(FL_OBJECT *, int);
//#define fl_set_browser_leftscrollbar fl_set_browser_leftslider
//inline void fl_set_browser_line_selectable(FL_OBJECT *, int, int);
//inline void fl_get_browser_dimension(FL_OBJECT *,int*,int*,int*,int*);
//inline void fl_set_browser_dblclick_callback(FL_OBJECT*,FL_CALLBACKPTR,long);
//inline void fl_set_browser_xoffset(FL_OBJECT *, FL_Coord);
//inline void fl_set_browser_scrollbarsize(FL_OBJECT *, int, int);
inline void fl_setdisplayed_browser_line(FL_OBJECT *o, int n, int i) {
    ((Fl_Browser*)o)->display(n,i);}
inline int fl_isdisplayed_browser_line(FL_OBJECT *o, int n) {
    return ((Fl_Browser*)o)->displayed(n);}

#include "Fl_Button.H"

#define FL_NORMAL_BUTTON	0
#define FL_TOUCH_BUTTON		4
#define FL_INOUT_BUTTON		5
#define FL_RETURN_BUTTON	6
#define FL_HIDDEN_RET_BUTTON	7
#define FL_PUSH_BUTTON		FL_TOGGLE_BUTTON
#define FL_MENU_BUTTON		9

Fl_Button *fl_add_button(uchar t,int x,int y,int w,int h,const char *l);
inline int fl_get_button(Fl_Object *b) {return ((Fl_Button*)b)->value();}
inline void fl_set_button(Fl_Object *b, int v) {((Fl_Button*)b)->value(v);}
inline int fl_get_button_numb(Fl_Object *) {return Fl::event_button();}
inline void fl_set_button_shortcut(Fl_Object *b, const char *s,int=0) {
    ((Fl_Button*)b)->shortcut(s);}
//#define fl_set_object_shortcut(b,s) fl_set_button_shortcut(b,s)

#include "Fl_Light_Button.H"
forms_constructor(Fl_Light_Button, fl_add_lightbutton)

#include "Fl_Round_Button.H"
forms_constructor(Fl_Round_Button, fl_add_roundbutton)
forms_constructor(Fl_Round_Button, fl_add_round3dbutton)

#include "Fl_Check_Button.H"
forms_constructor(Fl_Check_Button, fl_add_checkbutton)

inline Fl_Object *fl_add_bitmapbutton(int t,int x,int y,int w,int h,const char *l) {Fl_Object *o = fl_add_button(t,x,y,w,h,l); return o;}
inline void fl_set_bitmapbutton_data(Fl_Object *o,int a,int b,uchar *c) {
  (new Fl_Bitmap(c,a,b))->label(o);}  // does not delete old Fl_Bitmap!

inline Fl_Object *fl_add_pixmapbutton(int t,int x,int y,int w,int h,const char *l) {Fl_Object *o = fl_add_button(t,x,y,w,h,l); return o;}
inline void fl_set_pixmapbutton_data(Fl_Object *o,char * const * c) {
  (new Fl_Pixmap(c))->label(o);}  // does not delete old Fl_Pixmap!

// Fl_Canvas object not yet implemented!

#include "Fl_Chart.H"

forms_constructor(Fl_Chart, fl_add_chart)
inline void fl_clear_chart(FL_OBJECT *o) {
  ((Fl_Chart*)o)->clear();}
inline void fl_add_chart_value(FL_OBJECT *o, float v, const char *s, int c) {
  ((Fl_Chart*)o)->add(v,s,c);}
inline void fl_insert_chart_value(FL_OBJECT *o, int i, float v, const char *s, int c) {
  ((Fl_Chart*)o)->insert(i,v,s,c);}
inline void fl_replace_chart_value(FL_OBJECT *o, int i, float v, const char *s, int c) {
  ((Fl_Chart*)o)->replace(i,v,s,c);}
inline void fl_set_chart_bounds(FL_OBJECT *o, float a, float b) {
  ((Fl_Chart*)o)->bounds(a,b);}
inline void fl_set_chart_maxnumb(FL_OBJECT *o, int v) {
  ((Fl_Chart*)o)->maxsize(v);}
inline void fl_set_chart_autosize(FL_OBJECT *o, int v) {
  ((Fl_Chart*)o)->autosize(v);}
inline void fl_set_chart_lstyle(FL_OBJECT *o, int v) {
  ((Fl_Chart*)o)->textfont(v);}
inline void fl_set_chart_lsize(FL_OBJECT *o, int v) {
  ((Fl_Chart*)o)->textsize(v);}
inline void fl_set_chart_lcolor(FL_OBJECT *o, uchar v) {
  ((Fl_Chart*)o)->textcolor(v);}
#define fl_set_chart_lcol   fl_set_chart_lcolor

#include "Fl_Choice.H"

#define FL_NORMAL_CHOICE	0
#define FL_NORMAL_CHOICE2	0
#define FL_DROPLIST_CHOICE	0

forms_constructor(Fl_Choice, fl_add_choice)
inline void fl_clear_choice(FL_OBJECT *o) {
    ((Fl_Choice*)o)->clear();}
inline void fl_addto_choice(FL_OBJECT *o, const char *s) {
    ((Fl_Choice*)o)->add(s);}
inline void fl_replace_choice(FL_OBJECT *o, int i, const char *s) {
    ((Fl_Choice*)o)->replace(i-1,s);}
inline void fl_delete_choice(FL_OBJECT *o, int i) {
    ((Fl_Choice*)o)->remove(i-1);}
inline void fl_set_choice(FL_OBJECT *o, int i) {
    ((Fl_Choice*)o)->value(i-1);}
// inline void fl_set_choice_text(FL_OBJECT *, const char *);
inline int fl_get_choice(FL_OBJECT *o) {
    return ((Fl_Choice*)o)->value()+1;}
// inline const char *fl_get_choice_item_text(FL_OBJECT *, int);
// inline int fl_get_choice_maxitems(FL_OBJECT *);
inline const char *fl_get_choice_text(FL_OBJECT *o) {
    return ((Fl_Choice*)o)->text();}
inline void fl_set_choice_fontsize(FL_OBJECT *o, int x) {
    ((Fl_Choice*)o)->textsize(x);}
inline void fl_set_choice_fontstyle(FL_OBJECT *o, int x) {
    ((Fl_Choice*)o)->textfont(x);}
// inline void fl_set_choice_item_mode(FL_OBJECT *, int, unsigned);
// inline void fl_set_choice_item_shortcut(FL_OBJECT *, int, const char *);

#include "Fl_Clock.H"
forms_constructort(Fl_Clock, fl_add_clock)
inline void fl_get_clock(FL_OBJECT *o,int *h,int *m,int *s) {
    *h = ((Fl_Clock*)o)->hour();
    *m = ((Fl_Clock*)o)->minute();
    *s = ((Fl_Clock*)o)->second();
}

#include "Fl_Counter.H"
forms_constructor(Fl_Counter, fl_add_counter)
inline void fl_set_counter_value(FL_OBJECT *o, float v) {
    ((Fl_Counter*)o)->value(v);}
inline void fl_set_counter_bounds(FL_OBJECT *o, float a, float b) {
    ((Fl_Counter*)o)->bounds(a,b);}
inline void fl_set_counter_step(FL_OBJECT *o, float a, float b) {
    ((Fl_Counter*)o)->step(a,b);}
inline void fl_set_counter_precision(FL_OBJECT *o, int v) {
    ((Fl_Counter*)o)->precision(v);}
inline void fl_set_counter_return(FL_OBJECT *o, int v) {
    ((Fl_Counter*)o)->when(v|FL_WHEN_RELEASE);}
inline float fl_get_counter_value(FL_OBJECT *o) {
    return ((Fl_Counter*)o)->value();}
inline void fl_get_counter_bounds(FL_OBJECT *o, float *a, float *b) {
    ((Fl_Counter*)o)->bounds(a, b);}
//inline void fl_set_counter_filter(FL_OBJECT *,const char *(*)(FL_OBJECT *,float,int));

// Cursor stuff cannot be emulated because it uses X stuff
inline void fl_set_cursor(Fl_Window *w, int c) {w->cursor(c);}
#define FL_INVISIBLE_CURSOR FL_CURSOR_NONE
#define FL_DEFAULT_CURSOR FL_CURSOR_DEFAULT

#include "Fl_Dial.H"

#define FL_DIAL_COL1 FL_GRAY
#define FL_DIAL_COL2 37

forms_constructor(Fl_Dial, fl_add_dial)
inline void fl_set_dial_value(Fl_Object *o, float v) {
  ((Fl_Dial*)o)->value(v);}
inline float fl_get_dial_value(Fl_Object *o) {
  return ((Fl_Dial*)o)->value();}
inline void fl_set_dial_bounds(Fl_Object *o, float a, float b) {
  ((Fl_Dial*)o)->bounds(a, b);}
inline void fl_get_dial_bounds(Fl_Object *o, float *a, float *b) {
  ((Fl_Dial*)o)->bounds(a, b);}
inline void fl_set_dial_return(Fl_Object *o, int i) {
  ((Fl_Dial*)o)->when(i|FL_WHEN_RELEASE);}
inline void fl_set_dial_angles(FL_OBJECT *o, int a, int b) {
  ((Fl_Dial*)o)->angles(a,b);}
//inline void fl_set_dial_cross(FL_OBJECT *o, int);
inline void fl_set_dial_direction(FL_OBJECT *o, uchar d) {
  ((Fl_Dial*)o)->direction(d);}
inline void fl_set_dial_step(Fl_Object *o, float v) {
  ((Fl_Dial*)o)->step(v);}

// Frames:

inline Fl_Object *fl_add_frame(int i,int x,int y,int w,int h,const char *l) {
  return fl_add_box(i,x-3,y-3,w+6,h+6,l);}

// labelframe nyi
inline Fl_Object *fl_add_labelframe(int i,int x,int y,int w,int h,const char *l) {
  Fl_Object *o = fl_add_box(i,x-3,y-3,w+6,h+6,l);
  o->align(FL_ALIGN_TOP_LEFT);
  return o;
}

#include "Fl_Free.H"
inline Fl_Free *
fl_add_free(int t,float x,float y,float w,float h,const char *l,
	    FL_HANDLEPTR hdl) {
 return (Fl_Free*)(fl_add_new(
   new Fl_Free(t,int(x),int(y),int(w),int(h),l,hdl)));
}

#include "fl_ask.H"
#include "fl_show_colormap.H"

inline int fl_show_question(const char *c, int) {return fl_ask(c);}
inline void fl_show_alert(const char *a,const char*b,const char*c,int) {
  fl_show_alert(a,b,c);}
inline void fl_set_goodies_font(uchar a, uchar b) {fl_message_font(a,b);}
#define fl_show_messages fl_message
inline int fl_show_choices(const char *c,int n,const char *b1,const char *b2,
			   const char *b3, int) {
  return fl_show_choice(0,c,0,n,b1,b2,b3);
}

#include "filename.H"
#include "fl_file_chooser.H"
inline int do_matching(char *a, const char *b) {return filename_match(a,b);}

// Forms-compatable file chooser (implementation in fselect.C):
char* fl_show_file_selector(const char *message,const char *dir,
			    const char *pat,const char *fname);
char*	fl_get_directory();
char*	fl_get_pattern();
char*	fl_get_filename();

#include "Fl_Input.H"
forms_constructor(Fl_Input, fl_add_input)
inline void fl_set_input(Fl_Object *o, const char *v) {
    ((Fl_Input *)o)->value(v);}
inline void fl_set_input_return(Fl_Object *o, int x) {
    ((Fl_Input *)o)->when(x | FL_WHEN_RELEASE);}
inline void fl_set_input_color(Fl_Object *o, int a, int b) {
    ((Fl_Input *)o)->textcolor(a);
    ((Fl_Input *)o)->cursor_color(b);
}
// inline void fl_set_input_scroll(FL_OBJECT *, int);
inline void fl_set_input_cursorpos(Fl_Object *o, int x, int /*y*/) {
  ((Fl_Input*)o)->position(x);}
// inline void fl_set_input_selected(FL_OBJECT *, int);
// inline void fl_set_input_selected_range(FL_OBJECT *, int, int);
// inline void fl_set_input_maxchars(FL_OBJECT *, int);
// inline void fl_set_input_format(FL_OBJECT *, int, int);
// inline void fl_set_input_hscrollbar(FL_OBJECT *, int);
// inline void fl_set_input_vscrollbar(FL_OBJECT *, int);
// inline void fl_set_input_xoffset(FL_OBJECT *, int);
// inline void fl_set_input_topline(FL_OBJECT *, int);
// inline void fl_set_input_scrollbarsize(FL_OBJECT *, int, int);
// inline int fl_get_input_topline(FL_OBJECT *);
// inline int fl_get_input_screenlines(FL_OBJECT *);
inline int fl_get_input_cursorpos(Fl_Object *o, int*x, int*y) {
  *x = ((Fl_Input*)o)->position(); *y = 0; return *x;}
// inline int fl_get_input_numberoflines(FL_OBJECT *);
// inline void fl_get_input_format(FL_OBJECT *, int *, int *);
inline const char *fl_get_input(Fl_Object *o) {return ((Fl_Input*)o)->value();}

#include "Fl_Menu_Button.H"

// types are not implemented, they all act like FL_PUSH_MENU:
#define FL_TOUCH_MENU		0
#define FL_PUSH_MENU		1
#define FL_PULLDOWN_MENU	2
forms_constructor(Fl_Menu_Button, fl_add_menu)

inline void fl_clear_menu(FL_OBJECT *o) {
    ((Fl_Menu_Button*)o)->clear();}
inline void fl_set_menu(FL_OBJECT *o, const char *s) {
    ((Fl_Menu_Button*)o)->clear(); ((Fl_Menu_Button*)o)->add(s);}
inline void fl_addto_menu(FL_OBJECT *o, const char *s) {
    ((Fl_Menu_Button*)o)->add(s);}
inline void fl_replace_menu_item(FL_OBJECT *o, int i, const char *s) {
    ((Fl_Menu_Button*)o)->replace(i-1,s);}
inline void fl_delete_menu_item(FL_OBJECT *o, int i) {
    ((Fl_Menu_Button*)o)->remove(i-1);}
inline void fl_set_menu_item_shortcut(FL_OBJECT *o, int i, const char *s) {
    ((Fl_Menu_Button*)o)->shortcut(i-1,s);}
inline void fl_set_menu_item_mode(FL_OBJECT *o, int i, long x) {
    ((Fl_Menu_Button*)o)->mode(i-1,x);}
inline void fl_show_menu_symbol(FL_OBJECT *, int ) {
/*    ((Fl_Menu_Button*)o)->show_menu_symbol(i); */}
// inline void fl_set_menu_popup(FL_OBJECT *, int);
inline int fl_get_menu(FL_OBJECT *o) {
    return ((Fl_Menu_Button*)o)->value()+1;}
inline const char *fl_get_menu_item_text(FL_OBJECT *o, int i) {
    return ((Fl_Menu_Button*)o)->text(i);}
inline int fl_get_menu_maxitems(Fl_Object *o) {
    return ((Fl_Menu_Button*)o)->size();}
inline int fl_get_menu_item_mode(FL_OBJECT *o, int i) {
    return ((Fl_Menu_Button*)o)->mode(i);}
inline const char *fl_get_menu_text(FL_OBJECT *o) {
    return ((Fl_Menu_Button*)o)->text();}

#include "Fl_Positioner.H"
#define FL_NORMAL_POSITIONER	0
forms_constructor(Fl_Positioner, fl_add_positioner)
inline void fl_set_positioner_xvalue(FL_OBJECT *o, float v) {
    ((Fl_Positioner*)o)->xvalue(v);}
inline float fl_get_positioner_xvalue(FL_OBJECT *o) {
    return ((Fl_Positioner*)o)->xvalue();}
inline void fl_set_positioner_xbounds(FL_OBJECT *o, float a, float b) {
    ((Fl_Positioner*)o)->xbounds(a,b);}
inline void fl_get_positioner_xbounds(FL_OBJECT *o, float *a, float *b) {
    ((Fl_Positioner*)o)->xbounds(a,b);}
inline void fl_set_positioner_yvalue(FL_OBJECT *o, float v) {
    ((Fl_Positioner*)o)->yvalue(v);}
inline float fl_get_positioner_yvalue(FL_OBJECT *o) {
    return ((Fl_Positioner*)o)->yvalue();}
inline void fl_set_positioner_ybounds(FL_OBJECT *o, float a, float b) {
    ((Fl_Positioner*)o)->ybounds(a,b);}
inline void fl_get_positioner_ybounds(FL_OBJECT *o, float *a, float *b) {
    ((Fl_Positioner*)o)->ybounds(a,b);}
inline void fl_set_positioner_xstep(FL_OBJECT *o, float v) {
    ((Fl_Positioner*)o)->xstep(v);}
inline void fl_set_positioner_ystep(FL_OBJECT *o, float v) {
    ((Fl_Positioner*)o)->ystep(v);}
inline void fl_set_positioner_return(FL_OBJECT *o, int v) {
    ((Fl_Positioner*)o)->when(v|FL_WHEN_RELEASE);}

#include "Fl_Slider.H"

#define FL_HOR_BROWSER_SLIDER FL_HOR_SLIDER
#define FL_VERT_BROWSER_SLIDER FL_VERT_SLIDER

forms_constructort(Fl_Slider, fl_add_slider)
#define FL_SLIDER_COL1 FL_GRAY
inline void fl_set_slider_value(Fl_Object *o, float v) {
    ((Fl_Slider*)o)->value(v);}
inline float fl_get_slider_value(Fl_Object *o) {
    return ((Fl_Slider*)o)->value();}
inline void fl_set_slider_bounds(Fl_Object *o, float a, float b) {
    ((Fl_Slider*)o)->bounds(a, b);}
inline void fl_get_slider_bounds(Fl_Object *o, float *a, float *b) {
    ((Fl_Slider*)o)->bounds(a, b);}
inline void fl_set_slider_return(Fl_Object *o, int i) {
    ((Fl_Slider*)o)->when(i|FL_WHEN_RELEASE);}
inline void fl_set_slider_step(Fl_Object *o, float v) {
    ((Fl_Slider*)o)->step(v);}
inline void fl_set_slider_increment(Fl_Object *o, float v, float) {
    ((Fl_Slider*)o)->page(short(v));}
inline void fl_set_slider_size(Fl_Object *o, float v) {
    ((Fl_Slider*)o)->size(v);}

#include "Fl_Value_Slider.H"
forms_constructor(Fl_Value_Slider, fl_add_valslider)

inline void fl_set_slider_precision(Fl_Object *o, int i) {
    ((Fl_Value_Slider*)o)->precision(i);}
// filter function!

// The forms text object was the same as an Fl_Box except it inverted the
// meaning of FL_ALIGN_INSIDE.  Implementation in forms.C
class Fl_FormsText : public Fl_Object {
protected:
    void draw();
public:
    Fl_FormsText(uchar b, int x, int y, int w, int h, const char *l=0)
	: Fl_Object(x,y,w,h,l) {box(b); align(FL_ALIGN_LEFT);}
};
#define FL_NORMAL_TEXT		0
forms_constructort(Fl_FormsText, fl_add_text)

#include "Fl_Timer.H"
forms_constructort(Fl_Timer, fl_add_timer)
inline void fl_set_timer(FL_OBJECT *o, float v) {((Fl_Timer*)o)->value(v);}
inline float fl_get_timer(FL_OBJECT *o) {return ((Fl_Timer*)o)->value();}
inline void fl_suspend_timer(FL_OBJECT *o) {((Fl_Timer*)o)->suspended(1);}
inline void fl_resume_timer(FL_OBJECT *o) {((Fl_Timer*)o)->suspended(0);}
inline void fl_set_timer_countup(FL_OBJECT *o,char d) {((Fl_Timer*)o)->direction(d);}
void fl_gettime(long *sec, long *usec);

// Fl_XYPlot nyi


// stuff from DDForms:

inline int fl_double_click() {return Fl::event_clicks();}
inline void fl_draw() {Fl::flush();}

#endif	/* define __FORMS_H__ */
