// fl_draw.H
// Portable drawing functions

#ifndef fl_draw_H
#define fl_draw_H

#include "Enumerations.H"  // for the color names

// Colors:
void	fl_color(uchar); // select indexed color
void	fl_color(uchar, uchar, uchar); // select actual color

// halftone patterns:
void fl_50percent();
void fl_50percent2();
void fl_100percent();

// clip:
struct Fl_Clip {short x, y, r, b;};
extern Fl_Clip fl_current_clip;
extern int fl_clipped;
void fl_clip(int x, int y, int w, int h);
void fl_pop_clip();

// rectangles tweaked to exactly fill the pixel rectangle:
void fl_rect(int x, int y, int w, int h);
void fl_rectf(int x, int y, int w, int h);

// line segments:
void fl_line(int x, int y, int x1, int y1);
void fl_line(int x, int y, int x1, int y1, int x2, int y2);

// closed line segments:
void fl_loop(int x, int y, int x1, int y1, int x2, int y2);
void fl_loop(int x, int y, int x1, int y1, int x2, int y2, int x3, int y3);

// filled polygons:
void fl_polygon(int x, int y, int x1, int y1, int x2, int y2);
void fl_polygon(int x, int y, int x1, int y1, int x2, int y2, int x3, int y3);

// draw rectilinear lines, horizontal segment first:
void fl_xyline(int x, int y, int x1);
void fl_xyline(int x, int y, int x1, int y2);
void fl_xyline(int x, int y, int x1, int y2, int x3);

// draw rectilinear lines, vertical segment first:
void fl_yxline(int x, int y, int y1);
void fl_yxline(int x, int y, int y1, int x2);
void fl_yxline(int x, int y, int y1, int x2, int y3);

// scalable drawing code (code in fl_vertex.C and fl_arc.C):
void fl_push_matrix();
void fl_pop_matrix();
void fl_scale(float x, float y);
void fl_scale(float x);
void fl_translate(float x, float y);
void fl_rotate(float d);
void fl_mult_matrix(float a, float b, float c, float d, float x, float y);
void fl_begin_line();
void fl_begin_loop();
void fl_begin_polygon();
void fl_vertex(float x, float y);
void fl_vertex(const float *p);
void fl_arc(float x, float y, float w, float h, int start, int end);
void fl_arc(float x, float y, float r, int start, int end);
void fl_circle(float x, float y, float w, float h);
void fl_circle(float x, float y, float r);
void fl_end();
// get and use transformed positions:
float fl_transform_x(float x, float y);
float fl_transform_y(float x, float y);
void fl_transformed_vertex(float x, float y);

// current font:
void fl_font(uchar fontid, int size);

// information you can get about the current font:
int   fl_height();	// using "size" should work ok
int   fl_descent();
float fl_width(const char *);
float fl_width(const char *, int n);
float fl_width(uchar);

// draw using current font:
void fl_draw(const char *, int x, int y);
void fl_draw(const char *, int n, int x, int y);
void fl_draw(const char *, int x, int y, int w, int h, uchar align);

// Draw arbitrary XForms symbols:
int fl_draw_symbol(const char *label,int x,int y,int w,int h,uchar col);
int fl_add_symbol(const char *name, void (*drawit)(uchar), int scalable);

// Draw arbitrary boxtype:
void fl_draw_box(uchar id, int x, int y, int w, int h, uchar c);

// images:
void fl_draw_image(const uchar *, int,int,int,int, int d=3, int ld=0);
void fl_draw_image_mono(const uchar *, int,int,int,int, int d=1, int ld=0);

// pixmaps:
int fl_pixmap_size(/*const*/ char * const *data, int &w, int &h);
int fl_draw_pixmap(/*const*/ char * const *data, int x,int y,uchar bg=FL_GRAY);

// other:
const char *fl_shortcut_label(const char *);
void fl_overlay_rect(int,int,int,int);
void fl_overlay_clear();
void fl_cursor(uchar, uchar=FL_BLACK, uchar=FL_WHITE);

#endif
