// Fl_Window.H

// The FL user interface library version 0.98
// Copyright (C) 1998 Digital Domain

#ifndef Fl_Window_H
#define Fl_Window_H

#include "Fl_Group.H"

#define FL_WINDOW 0xF0	// all subclasses have type() >= this

class Fl_Window : public Fl_Group {

  friend class Fl;

  Fl_Window* nextwindow_;
  const char* iconlabel_;
  const char* xclass_;
  ulong xid_;
  void *xjunk;
  void _Fl_Window();
  friend void Fl_Object::size_range(int,int,int,int,int,int,int);
  void sendxjunk();
  void mapraised();
  enum {	// values for flags()
    FL_MODAL = 4,
    FL_BORDER = 8,
    FL_FORCE_POSITION = 16,
    FL_FORCE_SIZE = 32,
    FL_MAPRAISED = 64 // X specific
  };
  static Fl_Window *current_;

protected:

  struct {short x,y,r,b;} damage_box;
  void make_xid(void* visual); // X specific
  virtual void draw();
  virtual void flush();
  void make_current(ulong xid);

public:
// These should be protected, but are public so that internal code
// in Fl.C can call them:
  void expose(int,int,int,int);
  virtual int handle(int);
  virtual ulong colormap() const ; // X specific
  static Fl_Window* find(ulong xid);

public:

  Fl_Window(int,int,int,int, const char* = 0);
  Fl_Window(int,int, const char* = 0);
  virtual ~Fl_Window();

  virtual void resize(int,int,int,int);
  void fullscreen();
  void fullscreen_off(int,int,int,int);
  void iconize();
  void hotspot(int x, int y, int offscreen = 0);
  void hotspot(const Fl_Object*, int offscreen = 0);
  void hotspot(const Fl_Object& p, int offscreen = 0) {hotspot(&p,offscreen);}
  void free_position()	{clear_flag(FL_FORCE_POSITION);}

  const char* label() const	{return Fl_Object::label();}
  const char* iconlabel() const	{return iconlabel_;}
  void label(const char*);
  void iconlabel(const char*);
  void label(const char* label, const char* iconlabel);
  const char* xclass() const	{return xclass_;}
  void xclass(const char* c)	{xclass_ = c;}

  void set_modal()	{set_flag(FL_MODAL);}
  uchar modal() const	{return flags() & FL_MODAL;}
  int border(int b);
  void clear_border()	{clear_flag(FL_BORDER);}
  uchar border() const	{return flags() & FL_BORDER;}

  virtual void show();
  virtual void hide();
  void show(int, char**);
  ulong shown() {return xid_;}

  int x_root() const ;
  int y_root() const ;
  int other_windows();
  Fl_Window* nextwindow() const {return nextwindow_;}

  ulong xid() const {return xid_;}
  static Fl_Window *current() {return current_;}
  void make_current() {make_current(xid());}

  // for back-compatability only:
  void cursor(uchar,uchar=0,uchar=7);

};

#endif
