/*	Fl_Value_Slider.H

	A slider with a box displaying the current value

*/

#ifndef Fl_Value_Slider_H
#define Fl_Value_Slider_H

#include "Fl_Slider.H"

class Fl_Value_Slider : public Fl_Slider {
    uchar textfont_, textsize_, textcolor_;
    uchar precision_;
protected:
    void draw();
    int handle(int);
public:
    Fl_Value_Slider(int x,int y,int w,int h, const char *l = 0);
    uchar precision() const {return precision_;}
    void precision(uchar a);
    uchar textfont() const {return textfont_;}
    void textfont(uchar s) {textfont_ = s;}
    uchar textsize() const {return textsize_;}
    void textsize(uchar s) {textsize_ = s;}
    uchar textcolor() const {return textcolor_;}
    void textcolor(uchar s) {textcolor_ = s;}
};

#endif
