// Fl_Text_Adjuster.H

// Edit text or drag to adjust floating point value.
// as suggested by Pierre Jasmin

// Current behavior:
// Dragging left mouse moves by step()
// Middle mouse is 5*step()
// Right mouse is 20*step()
// if step() is zero it uses (maximum()-minimum())/100
// clicking any mouse button puts insertion cursor there
// You can also navigate there with tab

// Bugs (?):
// No way to select region of text
// value is converted to/from text, which may produce different number
// than was written.
// Hard to control when callback is done when user edits text.  Focus
// should probably go away when user hits return?

#ifndef Fl_Text_Adjuster_H
#define Fl_Text_Adjuster_H

#include "Fl_Input.H"

class Fl_Text_Adjuster : public Fl_Input {
  float minimum_;
  float maximum_;
  float step_;
protected:
  int handle(int);
public:
  Fl_Text_Adjuster(int x,int y,int w,int h,const char *l=0);
  float value() const;
  int value(float v);
  float minimum() const {return minimum_;}
  void minimum(float v) {minimum_ = v;}
  float maximum() const {return maximum_;}
  void maximum(float v) {maximum_ = v;}
  float step() const {return step_;}
  void step(float v) {step_ = v;}
};

#endif
