// Fl_Tabs.C

// This is the "file card tabs" interface to allow you to put lots and lots
// of buttons and switches in a panel, as popularized by many toolkits.

// Each child object is a card, and it's label() is printed on the card tab.
// Clicking the tab makes that card visible.

#ifndef Fl_Tabs_H
#define Fl_Tabs_H

#include "Fl_Group.H"

class Fl_Tabs : public Fl_Group {
  Fl_Object *value_;
  Fl_Object *push_;
  int handle(int);
  void draw();
  int tab_right(int xpos, const Fl_Object *);
public:
  Fl_Object *value() const {return value_;}
  int value(Fl_Object *);
  Fl_Object *push() const {return push_;}
  int push(Fl_Object *);
  Fl_Tabs(int,int,int,int,const char * = 0);
  Fl_Object *which(int event_x, int event_y);
};

#endif
