// Fl_Slider.H

// The slider/scrollbar object.

#ifndef Fl_Slider_H
#define Fl_Slider_H

#ifndef Fl_Object_H
#include "Fl_Object.H"
#endif

// values for type(), lowest bit indicate horizontal:
#define FL_VERT_SLIDER		0
#define FL_HOR_SLIDER		1
#define FL_VERT_FILL_SLIDER	2
#define FL_HOR_FILL_SLIDER	3
#define FL_VERT_NICE_SLIDER	4
#define FL_HOR_NICE_SLIDER	5

class Fl_Slider : public Fl_Object {

  float min;
  float max;
  float value_;
  float step_;
  float size_;
  uchar slider_;
  short increment_,page_; // what arrow and page keys do
  void _Fl_Slider();

protected:

  int horizontal() const {return type()&1;}
  // these allow subclasses to put the slider in a smaller area:
  void draw(int, int, int, int);
  int handle(int, int, int, int, int);
  void draw();

public:

  int handle(int);
  Fl_Slider(int x,int y,int w,int h, const char *l = 0);
  Fl_Slider(uchar t,int x,int y,int w,int h, const char *l);

  void bounds(float, float);
  float minimum() const {return min;}
  void minimum(float a) {bounds(a,max);}
  float maximum() const {return max;}
  void maximum(float a) {bounds(min,a);}
  float value() const {return value_;}
  int value(float);	// returns true if any change
  int value(int windowtop,int windowsize,int first,int totalsize);
  float step() const {return step_;}
  void step(float v) {step_ = v;}
  float size() const {return size_;}
  void size(float v);
  short increment() const {return increment_;}
  void increment(short v) {increment_ = v;}
  short page() const {return page_;}
  void page(short v) {page_ = v;}
  uchar slider() const {return slider_;}
  void slider(uchar c) {slider_ = c;}

  void bounds(float *a, float *b) const {*a = min; *b = max;}
};

#endif

