// Fl_Positioner.H

// The positioner object from Forms, gives 2D input

#ifndef Fl_Positioner_H
#define Fl_Positioner_H

#ifndef Fl_Object_H
#include "Fl_Object.H"
#endif

class Fl_Positioner : public Fl_Object {

  float xmin, ymin;
  float xmax, ymax;
  float xvalue_, yvalue_;
  float xstep_, ystep_;

protected:

  // these allow subclasses to put the dial in a smaller area:
  void draw(int, int, int, int);
  int handle(int, int, int, int, int);
  void draw();

public:

  int handle(int);
  Fl_Positioner(int x,int y,int w,int h, const char *l=0);
  float xvalue() const {return xvalue_;}
  float yvalue() const {return yvalue_;}
  void value(float *a,float *b) const {*a = xvalue(); *b = yvalue();}
  int xvalue(float);
  int yvalue(float);
  int value(float,float);
  void xbounds(float, float);
  void ybounds(float, float);
  void xbounds(float *a, float *b) const {*a = xmin; *b = xmax;}
  void ybounds(float *a, float *b) const {*a = ymin; *b = ymax;}
  void xstep(float a) {xstep_ = a;}
  void ystep(float a) {ystep_ = a;}

};

#endif

