// Fl_Poll.H

// This is an "internal" data structure that only exists on Unix.  It
// is provided here so that you can use it without using the rest of FL,
// in case that is useful.

#ifndef Fl_Poll_H
#define Fl_Poll_H

#if HAVE_POLL
#include <poll.h>
#else
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
struct pollfd {int fd; short events; short revents;};
#define POLLIN 1
#define POLLOUT 4
#define POLLERR 8
#endif

class Fl_Poll {
  enum {	// more than this many fd's or timeout's will fail silently:
    MAXFD = 8,
    MAXTIMEOUT = 8,
    MAXTEST = 8
  };
#if !HAVE_POLL
  fd_set fdsets[3];
  int maxfd;
#endif
  int nfds;
  struct pollfd fds[MAXFD];
  struct {
    void (*cb)(int, void*);
    void* arg;
  } fd[MAXFD];
  int numtimeouts;
  struct {
    float time;
    void (*cb)(void*);
    void* arg;
  } timeout[MAXTIMEOUT+1];
  int numtests;
  struct {
    int (*test)(void*);
    void (*cb)(void*);
    void* arg;
  } test[MAXTEST];
  void (*idle)();
  unsigned long prevclock;
  int initclock;
  inline int timeout_ready();
  void call_timeouts();
public:
  void clear();
  void add(int fd, short events, void (*cb)(int,void*), void* v=0);
  void remove(int fd);
  void add_timeout(float t,void (*cb)(void*),void* v=0);
  void remove_timeout(void (*cb)(void*), void* = 0);
  void add_test(int (*test)(void*), void (*cb)(void*), void* v=0);
  void remove_test(int (*test)(void*), void (*cb)(void*), void* = 0);
  void set_idle(void (*cb)()) {idle = cb;}
  int wait();
  float wait(float);
  float reset();
  int check();
  int ready();
  void run() {for (;;) wait();}
};

extern Fl_Poll fl_poll;

#endif
