// Fl_Input_.H

#ifndef Fl_Input__H
#define Fl_Input__H

#ifndef Fl_Object_H
#include "Fl_Object.H"
#endif

#define FL_NORMAL_INPUT		0
#define FL_FLOAT_INPUT		1
#define FL_INT_INPUT		2
#define FL_HIDDEN_INPUT		3
#define FL_MULTILINE_INPUT	4
#define FL_SECRET_INPUT		5

class Fl_Input_ : public Fl_Object {

  uchar textfont_;
  uchar textsize_;
  uchar textcolor_, cursor_color_, selection_color_;
  char erase_cursor_only;

  char *value_; 	// the buffer
  int size_;		// strlen(value())
  int position_;	// cursor position 
  int mark_;		// other end of selection
  int bufsize;		// size of the buffer
  int xscroll_,yscroll_;
  int mu_p;

  const char * expand(const char *p, char *buf) const;
  float expandpos(const char *p,const char *e,const char *buf) const;
  void minimal_update(int,int);
  void minimal_update(int p);

protected:

  int wordboundary(int i) const;
  int lineboundary(int i) const;
  void drawtext(int,int,int,int);
  int up_down_position(int, int keepmark=0);
  void handle_mouse(int,int,int,int,int keepmark=0);
  int handletext(int e, int,int,int,int);
  void maybe_do_callback();

public:

  void resize(int,int,int,int);

  Fl_Input_(int,int,int,int,const char * = 0);
  ~Fl_Input_();

  int value(const char *);
  const char *value() const {return value_;}
  char index(int i) const {return value_[i];}
  int size() const {return size_;}

  int position() const {return position_;}
  int mark() const {return mark_;}
  int position(int p, int m);
  int position(int p) {return position(p,p);}
  int mark(int m) {return position(position(), m);}
  int replace(int,int,const char *,int=0);
  int cut() {return replace(position(), mark(), 0);}
  int cut(int n) {return replace(position(),position()+n,0);}
  int cut(int a, int b) {return replace(a,b,0);}
  int insert(const char *t,int l=0){return replace(position_,mark_,t,l);}
  int copy();
  int undo();
  int copy_cuts();

  uchar textfont() const {return textfont_;}
  void textfont(uchar s) {textfont_ = s;}
  uchar textsize() const {return textsize_;}
  void textsize(uchar s) {textsize_ = s;}
  uchar textcolor() const {return textcolor_;}
  void textcolor(uchar n) {textcolor_ = n;}
  uchar cursor_color() const {return cursor_color_;}
  void cursor_color(uchar n) {cursor_color_ = n;}
  uchar selection_color() const {return selection_color_;}
  void selection_color(uchar n) {selection_color_ = n;}

};

#endif 
