/*	Fl_Image.H	*/

#ifndef Fl_Image_H
#define Fl_Image_H

struct Fl_Image {
  const uchar *array;
  int w, h, d, ld;
  long id; // for internal use
  Fl_Image(const uchar *bits, int W, int H, int D=3, int LD=0) :
    array(bits), w(W), h(H), d(D), ld(LD), id(0) {}
  ~Fl_Image();
  void label(Fl_Object *); // set object's label to this image
};

void fl_draw(Fl_Image *b, int x, int y, int w, int h);

#endif
