// Fl_Group.H

#ifndef Fl_Group_H
#define Fl_Group_H

#ifndef Fl_Object_H
#include "Fl_Object.H"
#endif

#define FL_GROUP 0xE0 // all subclasses have type() >= this

class Fl_Group : public Fl_Object {

  Fl_Object** array_;
  Fl_Object* savedfocus_;
  Fl_Object* resizable_;
  int children_;

  int navigation(int = 0);
  static Fl_Group *current_;

protected:

  void draw();
  int handle(int);

public:

  void begin() {current_ = this;}
  void end() {current_ = (Fl_Group*)parent();}
  static Fl_Group *current() {return current_;}
  static void current(Fl_Group *g) {current_ = g;}

  int children() const {return children_;}
  Fl_Object* child(int n) const {return array()[n];}
  int find(const Fl_Object*) const;
  int find(const Fl_Object& o) const {return find(&o);}
  Fl_Object* const* array() const;

  void resize(int,int,int,int);
  Fl_Group(int,int,int,int, const char * = 0);
  virtual ~Fl_Group();
  void add(Fl_Object&);
  void add(Fl_Object* o) {add(*o);}
  void insert(Fl_Object&, int i);
  void insert(Fl_Object& o, Fl_Object* before) {insert(o,find(before));}
  void remove(Fl_Object&);
  void remove(Fl_Object* o) {remove(*o);}
  void resize(); // force size to surround contents, for Forms compatability
  void resizable(Fl_Object& o) {resizable_ = &o;}
  void resizable(Fl_Object* o) {resizable_ = o;}
  Fl_Object* resizable() const {return resizable_;}
  void add_resizable(Fl_Object& o) {resizable_ = &o; add(o);}

  // back compatability function:
  void focus(Fl_Object* o) {o->take_focus();}
  Fl_Object* & _ddfdesign_kludge() {return resizable_;}
  void flip();
};

#endif
