/*	Fl_Double_Window.H

	A window with a double-buffered context.  This is the default
	if FL is compiled without -DUSE_X.
	For -DUSE_X this will force "double buffering" by using a
	pixmap.  Memory intensive but works nicely.  Notice that
	the fl_doublebuf symbol is *not* set, since this does not
	demonstrate the annoying "swap" behavior of OpenGL.

*/

#ifndef Fl_Double_Window_H
#define Fl_Double_Window_H

#include "Fl_Window.H"

class Fl_Double_Window : public Fl_Window {
  ulong pixmap_; // used only when -DUSE_X
public:
  void show();
  void show(int a, char **b) {Fl_Window::show(a,b);}
  ulong pixmap() const {return pixmap_;}
  void flush();
  void resize(int,int,int,int);
  void hide();
  ~Fl_Double_Window();
  Fl_Double_Window(int W, int H, const char *l = 0)
    : Fl_Window(W,H,l) {pixmap_ = 0;}
  Fl_Double_Window(int X, int Y, int W, int H, const char *l = 0)
    : Fl_Window(X,Y,W,H,l) {pixmap_ = 0;}
};

#endif
