// Fl_Counter.H

// A numerical value with up/down step buttons.  From Forms.

#ifndef Fl_Counter_H
#define Fl_Counter_H

#ifndef Fl_Object_H
#include "Fl_Object.H"
#endif

// values for type():
#define FL_NORMAL_COUNTER	0
#define FL_SIMPLE_COUNTER	1

class Fl_Counter : public Fl_Object {

  float value_;
  float min,max;
  float step_,lstep_;
  uchar precision_;
  uchar mouseobj;
  uchar down_box_;
  static void repeat_callback(void *);
  int calc_mouseobj();
  void increment();

protected:

  void draw();

public:

  int handle(int);
  Fl_Counter(int,int,int,int,const char * = 0);
  ~Fl_Counter();
  float value() const {return value_;}
  int value(float);
  float minimum() const {return min;}
  void minimum(float a) {min = a;}
  float maximum() const {return max;}
  void maximum(float a) {max = a;}
  float step() const {return step_;}
  float lstep() const {return lstep_;}
  void step(float a) {step_ = a; lstep_ = 10*a;}
  void lstep(float a) {lstep_ = a;}
  uchar precision() const {return precision_;}
  void precision(uchar v) {precision_ = v;}
  uchar down_box() const {return down_box_;}
  void down_box(uchar b) {down_box_ = b;}
  // for compatability only:
  void bounds(float *a,float *b) const {*a = min; *b = max;}
  void bounds(float a,float b) {min = a; max = b;}
  void step(float a,float b) {step_ = a; lstep_ = b;}
};

#endif

