/*	Fl_Button.H

	The button object.

	This is also the base class for a whole slew of subclasses,
	all of which have names ending in "button".
*/

#ifndef Fl_Button_H
#define Fl_Button_H

#ifndef Fl_Object_H
#include "Fl_Object.H"
#endif

// types for subclasses:
#define FL_TOGGLE_BUTTON	1
#define FL_RADIO_BUTTON		(FL_RESERVED_TYPE+2)
#define FL_HIDDEN_BUTTON	3 // for Forms compatability

class Fl_Button : public Fl_Object {

  const char *shortcut_;
  char value_;
  char oldval;
  uchar down_box_;

protected:

  virtual void draw();

public:

  virtual int handle(int);
  Fl_Button(int,int,int,int,const char * = 0);
  int value(int);
  char value() const {return value_;}
  int set() {return value(1);}
  int clear() {return value(0);}
  void setonly(); // this should only be called on FL_RADIO_BUTTONs
  const char *shortcut() const {return shortcut_;}
  void shortcut(const char *s) {shortcut_ = s;}
  uchar down_box() const {return down_box_;}
  void down_box(uchar b) {down_box_ = b;}
  uchar down_color() const {return color2();}
  void down_color(uchar c) {color2(c);}

};

#endif
