/*	Fl_Bitmap.H	*/

#ifndef Fl_Bitmap_H
#define Fl_Bitmap_H

struct Fl_Bitmap {
  const uchar *array;
  int w, h;
  long id; // for internal use
  Fl_Bitmap(const uchar *bits, int W, int H) :
    array(bits), w(W), h(H), id(0) {}
  Fl_Bitmap(const char *bits, int W, int H) :
    array((const uchar *)bits), w(W), h(H), id(0) {}
  ~Fl_Bitmap();
  void label(Fl_Object *); // set object's label to this bitmap
};

void fl_draw(Fl_Bitmap *b, int x, int y, int w, int h);

#endif
