/*	Fl_Adjuster.H

	3-button "slider", made for Nuke

*/

#ifndef Fl_Adjuster_H
#define Fl_Adjuster_H

#ifndef Fl_Object_H
#include "Fl_Object.H"
#endif

class Fl_Adjuster : public Fl_Object {
    float min;
    float max;
    float val;
    float step_;
    int drag;
    float ix;
    float ival;
protected:
    void draw();
    int handle(int);
public:
    Fl_Adjuster(int x,int y,int w,int h,const char *l=0);
    float value() const {return val;}
    void value(float v) {val = v;}
    void bounds(float a,float b) {min = a; max = b;}
    void bounds(float *a,float *b) const {*a = min; *b = max;}
    float step() const {return step_;}
    void step(float v) {step_ = v;}
};

#endif
