// Fl.H

// The FL user interface library version 0.98
// Copyright (C) 1998 Digital Domain

// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.

// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// Written by Bill Spitzak spitzak@d2.com
// Digital Domain
// 300 Rose Avenue
// Venice, CA 90291

#ifndef Fl_H
#define Fl_H

#include "Enumerations.H"

class Fl_Label;
typedef int (Fl_LabelFunction)(const Fl_Label*, int,int,int,int, uchar align);
typedef void (Fl_BoxFunction)(int,int,int,int, uchar color);

class Fl {
  Fl() {}; // no constructor!
  ~Fl() {}; // no destructor!

#ifdef _FL_IMPLEMENTATION_H
public:
#endif

  friend class Fl_Object;
  friend class Fl_Window;

  static int e_x,e_y,e_x_root,e_y_root;
  static unsigned int e_state;
  static int e_clicks;
  static int e_is_click;
  static int e_keysym;
  static char* e_text;
  static ulong e_time;
  static Fl_Object* belowmouse_;
  static Fl_Object* pushed_;
  static Fl_Object* focus_;
  static int damage_;
  static Fl_Window* first_;
  static char* selection_;
  static int selection_length_;
  static Fl_Object* selection_owner_;

  enum {BUTTON = 0xFEE8}; // value for keysym for button 0
  static void damage(int x) {damage_ = x;}

public:

  // argument parsers:
  static int arg(int, char**, int&);
  static int args(int, char**, int&, int (*)(int,char**,int&) = 0);
  static const char* const help;
  static void args(int, char**);

  // things called by initialization:
  static void display(const char*);
  static int visual(int mode);
  static int gl_visual(int mode, int *alist=0);
  static void foreground(uchar, uchar, uchar);
  static void background(uchar, uchar, uchar);
  static void background2(uchar, uchar, uchar);

  // execution:
  static int wait();
  static float wait(float time);
  static float reset();
  static int check();
  static int ready();
  static void run() {for (;;) wait();}
  static Fl_Object* readqueue();
  static void add_timeout(float t,void (*cb)(void*),void* v=0);
  static void remove_timeout(void (*cb)(void*), void* = 0);
  static void add_fd(int fd, int when, void (*cb)(int, void*), void* = 0);
  static void add_fd(int fd, void (*cb)(int, void*), void* = 0);
  static void remove_fd(int);
  static void set_idle(void (*cb)());
  static int damage() {return damage_;}
  static void redraw();
  static void flush();
  static void (*atclose)(Fl_Window*, void*);
  static void set_atclose(void (*cb)(Fl_Window*, void*)) {atclose = cb;}
  static void default_atclose(Fl_Window*, void*);
  static void (*abort)(const char*, ...);
  static void set_abort(void (*cb)(const char*, ...)) {abort = cb;}
  static void default_abort(const char*, ...);
  static void mouse_position(int &,int &);

  // event information:
  static int event_x()		{return e_x;}
  static int event_y()		{return e_y;}
  static int event_x_root()	{return e_x_root;}
  static int event_y_root()	{return e_y_root;}
  static int event_clicks()	{return e_clicks;}
  static void event_clicks(int i) {e_clicks = i;}
  static int event_is_click()	{return e_is_click;}
  static void event_is_click(int i) {e_is_click = i;} // only 0 works!
  static int event_button()	{return e_keysym-BUTTON;}
  static unsigned int event_state() {return e_state;} // X only
  static int event_shift()	{return e_state&1;}
  static int event_capslock()	{return e_state&2;}
  static int event_ctrl()	{return e_state&4;}
  static int event_alt()	{return e_state&8;}
  static int event_buttons()	{return e_state&0xff00;}
  static int event_button1()	{return e_state&0x100;}
  static int event_button2()	{return e_state&0x200;}
  static int event_button3()	{return e_state&0x400;}
  static int event_keypad()	{return e_keysym>=0xFF7F&&e_keysym<0xFFBE;}
  static int event_key()	{return e_keysym;}
  static const char* event_text() {return e_text;}
  static ulong event_time()	{return e_time;} // X only
  static int event_inside(int,int,int,int);
  static int event_inside(const Fl_Object*);
  static int test_shortcut(const char*);

  // event destinations:
  static Fl_Object* belowmouse() {return belowmouse_;}
  static void belowmouse(Fl_Object*);
  static Fl_Object* pushed()	{return pushed_;}
  static void pushed(Fl_Object*);
  static Fl_Object* focus()	{return focus_;}
  static void focus(Fl_Object*);
  static Fl_Window* first()	{return first_;}
  static void add_handler(int (*h)(int));
  static void grab();
  static void release();

  // cut/paste:
  static Fl_Object* selection_owner() {return selection_owner_;}
  static void selection_owner(Fl_Object*);
  static const char* selection() {return selection_;}
  static int selection_length() {return selection_length_;}
  static void selection(Fl_Object &owner, const char* stuff, int len);
  static void paste(Fl_Object &receiver);

  // screen size:
  static int x() {return 0;}
  static int y() {return 0;}
  static int w();
  static int h();

  // changing the color map:
  static uchar	set_color(uchar, uchar, uchar, uchar);
  static uchar	set_color(uchar, unsigned);
  static uchar	set_color(uchar, uchar, uchar);
  static uchar	set_color(unsigned);
  static unsigned get_color(uchar);
  static void	get_color(uchar, uchar&, uchar&, uchar&);

  // define fonts:
  static const char* get_font(uchar fontid);
  static uchar set_font(uchar fontid, const char*);
  static uchar set_font(uchar fontid, uchar from);
  static uchar set_font(const char*);

  // list all available font names:
  static void font_enumerate(void (*cb)(const char*, const int*, int));

  // define labeltypes:
  static Fl_LabelFunction* get_labeltype(uchar id);
  static uchar set_labeltype(uchar id, Fl_LabelFunction*);
  static uchar set_labeltype(uchar id, uchar from);
  static uchar set_labeltype(Fl_LabelFunction*);
  static void enable_symbols();

  // define boxtypes:
  static Fl_BoxFunction* get_boxtype(uchar id);
  static uchar set_boxtype(uchar id, Fl_BoxFunction*);
  static uchar set_boxtype(Fl_BoxFunction*);
  static uchar set_boxtype(uchar id, uchar from);
  static void set_box_deltas(uchar t, uchar, uchar, uchar, uchar);
  static int box_dx(uchar);
  static int box_dy(uchar);
  static int box_dw(uchar);
  static int box_dh(uchar);

};

//extern class Fl* fl; // for back-compatability fl->foo() calls

#endif
