/**************************************************************************
              simple.c is in the public domain
**************************************************************************/
 
#include <dore/dore.h>

int main (void)
{
	DtObject device, frame, view, studio_group, object_group;
	static DtColorRGB red_col = {1.0, 0.0, 0.0};

	DsInitialize(0);
	device = DoDevice("ps", " ");
	frame = DoFrame();
	DdSetFrame(device, frame);
	view = DoView();
	DgAddObjToGroup(DfInqViewGroup(frame), view);

	studio_group = DoGroup(DcTrue);
		DgAddObj(DoTranslate(0.0, 0.0, 4.0));
		DgAddObj(DoPerspective(40.0, -0.1, -5.0));
		DgAddObj(DoCamera());
		DgAddObj(DoLight());
	DgClose();

	object_group = DoGroup(DcTrue);
		DgAddObj(DoRepType(DcSurface));
		DgAddObj(DoDiffuseColor(DcRGB, red_col));
		DgAddObj(DoPrimSurf(DcSphere));
	DgClose();

	DgAddObjToGroup(DvInqDefinitionGroup(view), studio_group);
	DgAddObjToGroup(DvInqDisplayGroup(view), object_group);

	DdUpdate(device);
	printf("Hit return to exit.\n");
	getchar();

	DsTerminate();
}
