/* zlib interface functions    */
/* Written by Tom Kludy 9/2/96 */
/* these need documentation..  */

#include "zfunc.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>

#ifdef ANSI_COMPLIANT
#include <stdarg.h>
#endif /* ANSI_COMPLIANT */

#ifdef WIN32
#include <fcntl.h>
#include <io.h>
#include "../zlib/zlib.h"
#else
#include <zlib.h>
#endif /* WIN32 */
#include <sys/stat.h>
#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>
#define ERROR(string) printf("%s(%d): %s\n",__FILE__,__LINE__,string);

struct _bufflist;

typedef struct _bufflist {
  gzFile fd;
  long fpos;
  char *head;
  char *tail;
  char buffer[BUFFSIZE];
  char pushback[MAX_PUSHBACK];
  char ispushed;
  struct _bufflist *next;
} bufflist;

typedef bufflist *bufflist_p;

static bufflist_p buffroot=NULL;


int zfungets(s, fd)
char *s;
gzFile fd;
{
  bufflist_p bufp;

  for(bufp = buffroot; (bufp != NULL) && (bufp->fd != fd); bufp = bufp->next);

  /* Error conditions */
  if(bufp == NULL) return(1);    /* no buffer for this file           */
  if(bufp->ispushed) return(1);  /* this buffer's already been pushed */

  bufp->ispushed = 1;
  strcpy(bufp->pushback, s);
  return(0);
}


char *z_fgets(s, size, fd, brk)
char *s;
int size;
gzFile fd;
char brk;
{
  bufflist_p bufp, oldroot;
  char *p;
  int len;

  bufp = buffroot;

  /* find the right buffer */
  while(bufp) {
    if(bufp->fd == fd) break;
    bufp = bufp->next;
  }

  if(!bufp) {

    /* if there isn't one already, create one */
    bufp = (bufflist_p)malloc(sizeof(bufflist));
    if(!bufp) {
      fprintf(stderr, "Error during malloc: %s(%d)\n", __FILE__,__LINE__);
      exit(1);
    }

    /* now fill it in */
    bufp->fd = fd;
    bufp->fpos = 0;
    bufp->head = bufp->buffer;
    bufp->tail = bufp->buffer;
    bufp->ispushed = 0;
    
    /* link it to the rest */
    oldroot = buffroot;
    buffroot = bufp;
    bufp->next = oldroot;
  }

  /* refill the buffer from the file */
  if(bufp->tail < bufp->head) {
    bufp->tail += gzread(fd, bufp->tail, (bufp->head - bufp->tail - 1));
  } else {
    bufp->tail += gzread(fd, bufp->tail, (&(bufp->buffer[BUFFSIZE]) -
                                          bufp->tail - 1));
    if(bufp->head > bufp->buffer) {
      bufp->tail += gzread(fd, bufp->tail, 1);
      if(bufp->tail >= &(bufp->buffer[BUFFSIZE])) {
        bufp->tail = bufp->buffer;
        bufp->tail += gzread(fd, bufp->tail, (bufp->head - bufp->tail - 1));
      }
    }
  }

  /* fill output buffer */
  p=s;
  len=0;

  /* If something has been pushed back, pull that out now */
  /* limitations here: brk can't be \0; size & brk must be same throughout */
  if(bufp->ispushed) {
    strcpy(s, bufp->pushback);
    bufp->ispushed=0;
    return(s);
  }

  if(bufp->head == bufp->tail) {
    return(NULL);
  }
  
  while((bufp->head != bufp->tail) && (len < size)) {
    *p = *(bufp->head);
    bufp->head++;
    if(bufp->head >= &(bufp->buffer[BUFFSIZE]))
      bufp->head = bufp->buffer;
    bufp->fpos++;
    len++;
    if(*p == brk) {
      p++;
      *p = 0;
      break;
    }
    p++;
  }
  
  if((*p != 0) && (len < size)) {
    if(bufp->head == bufp->tail) {
      *p = 0;
    }
  }

  return(s);
}


int zfclose(fd)
gzFile fd;
{
  bufflist_p bufp, fromp;

  bufp=buffroot;
  fromp=NULL;
  
  while(bufp) {
    if(bufp->fd == fd) {
      if(fromp) {
        fromp->next = bufp->next;
      } else {
        buffroot = bufp->next;
      }
      free(bufp);
      break;
    }
    fromp=bufp;
    bufp=bufp->next;
  }

  return(gzclose(fd));
}


gzFile z_fopen(path, mode, compress)
char *path;
char *mode;
int compress;
{
  char path2[MAX_FNAMELEN];
  gzFile f;
  FILE *fn;
  int ok = 0;
  char newmode[10];

  sprintf(newmode, "%sb", mode);

  sprintf(path2, "%s.gz", path);

  if((f=gzopen(path2, newmode)) == NULL) {
    if((compress) && (*mode == 'r')) {
      if((fn = fopen(path, newmode)) != NULL) {
        if((f = gzopen(path2, "w9b")) != NULL) {
          ok=gz_compress(fn, f);
        }
      }

      if((ok) && (compress > 1)) {
        if(remove(path)) {
          fprintf(stderr, "Error deleting file: %s\n", path);
	  fprintf(stderr, "errno: %d\n", errno);
        }
      }
      if(ok) {
        f=gzopen(path2, newmode);
      }
    }
    if(f == NULL) {
      f=gzopen(path, newmode);
    }
  }

  return f;
}


long zftell(fd)
gzFile fd;
{
  bufflist_p bufp;
  long ans=0;
  
  bufp=buffroot;

  while(bufp) {
    if(bufp->fd == fd) {
      ans=bufp->fpos;
      break;
    }
    bufp=bufp->next;
  }

  return(ans);
}


/* Following function taken directly from libz's minigzip program, */
/* with a couple of modifications / bug fixes                      */

/* ===========================================================================
 * Compress input to output then close both files.
 */
int gz_compress(in, out)
    FILE   *in;
    gzFile out;
{
    char buf[BUFFSIZE+1];
    int len;
    int err;

    for (;;) {
        len = fread(buf, 1, sizeof(buf), in);
        if (ferror(in)) {
            perror("fread");
            return(0);
        }
        if (len == 0) break;
        buf[len] = '\0';
        
        if (gzwrite(out, buf, (unsigned)len) != len) {
          ERROR(gzerror(out, &err));
          return(0);
        }
    }
    fclose(in);
    if (gzclose(out) != Z_OK) {
      ERROR("failed gzclose");
      return(0);
    }

    return(1);
}

#ifdef ANSI_COMPLIANT

int zfprintf(gzFile f, char *fmt, ...)
{
  va_list ap;
  char buf[BUFFSIZE + 1];
  int ok;

  va_start(ap, fmt);
  vsprintf(buf, fmt, ap);
  va_end(ap);

  ok=gzwrite(f, buf, strlen(buf));
  return(ok);
}

#endif /* ANSI_COMPLIANT */
