/* test out the zfunc functions */

#include <zlib.h>
#include <zfunc.h>

void main(void) {
  FILE *f;
  gzFile gzf;
  char buffer[4096];
  
  printf("Creating a simple file..\n");

  f=fopen("output", "w");
  fprintf(f, "I am happy and fulfilled in my well-paying job\n");
  fprintf(f, "Duct tape is like the force; it has a dark side and a light side, and it binds  the universe together.\n");
  fprintf(f, "Hard work never hurt anybody, but why take the chance?\n");
  fprintf(f, "The beatings will continue until morale improves.\n");
  fclose(f);

  printf("File created.  Its contents are:\n------\n");

  f=fopen("output", "r");
  while(fgets(buffer, sizeof(buffer), f)) {
    printf("%s", buffer);
  }
  fclose(f);

  printf("-----\nNow, I will read it using the zfunc functions:\n-----\n");

  gzf=zfopen("output", "r");
  while(zfgets(buffer, sizeof(buffer), gzf)) {
    printf("%s", buffer);
  }
  zfclose(gzf);

  printf("-----\nThe output of ls -l right now is:\n-----\n");
  system("ls -l output");
  printf("-----\nAfter the file is compressed:\n-----\n");

  f=fopen("output", "r");
  gzf=zfopen("output", "w9");
  gz_compress(f, gzf);

  system("ls -l output output.gz");

  printf("-----\nNow using zfgets to read it again:\n-----\n");

  gzf=zfopen("output", "r");
  while(zfgets(buffer, sizeof(buffer), gzf)) {
    printf("%s", buffer);
  }
  zfclose(gzf);

  system("rm -f output");
  system("rm -f output.gz");

#ifdef ANSI_COMPLIANT

  printf("-----\nNow, writing a new file using zfprintf this time..\n");
  
  gzf=zfopen("output", "w9");
  zfprintf(f, "I am happy and fulfilled in my well-paying job\n");
  zfprintf(f, "Duct tape is like the force; it has a dark side and a light side, and it binds  the universe together.\n");
  zfprintf(f, "Hard work never hurt anybody, but why take the chance?\n");
  zfprintf(f, "The beatings will continue until %s improves.\n", "morale");
  zfclose(f);

  printf("..and reading it back:\n-----\n");

  gzf=zfopen("output", "r");
  while(zfgets(buffer, sizeof(buffer), gzf)) {
    printf("%s", buffer);
  }
  zfclose(gzf);
  
  system("rm -f output.gz");

#endif /* ANSI_COMPLIANT */
  
  printf("-----\nDone testing..\n");
}
