/*
   cole - A free C OLE library.
   cole test.
   Copyright 1998, 1999  Roberto Arturo Tena Sanchez

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published  by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
/*
   Roberto Arturo Tena Sanchez <arturo@directmail.org>
 */


#include <stdio.h>

#include <oledecod.h>
#include <olecod.h>


int
main (int argc, char **argv)
{
  int result;
  pps_entry *stream_tree;
  U32 root_stream;


  if (argc != 3)
    {
      fprintf (stderr, "cole test.\nUsage: test srcFILE destFILE.\nOutput should be _0 0 0_\n");
      return 1;
    }


  result = OLEdecode (argv[1], &stream_tree, &root_stream, 0);
  printf ("_%d ", result);
  if (result == 0)
  {
    result = OLEcode (argv[2], 1, stream_tree, root_stream);
    printf ("%d ", result);
    if (result == 0)
    {
      result = freeOLEtree (stream_tree);
      printf ("%d_", result);
    }
  }
  printf ("\n");

  return result;
}
