/*
   OLEcode - Code streams to a Microsoft OLE 2 file.
   Copyright 1998, 1999  Roberto Arturo Tena Sanchez

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
   Released under GPL, written by Arturo Tena <arturo@Directmail.org>
 */

#ifndef OLECOD_H
#define OLECOD_H

#ifdef __cplusplus
extern "C" {
#endif


#include <stdlib.h>

#include "oledecod.h" /* to get pps_entry */
#include "support.h"
#include <assert.h>
#include <string.h>

/*
  Exit codes:
  0 = All goes OK.
  1 = error writting in OLEfilename, can use perror
  2 = trunc == 0 and file exist
  3 = can't create OLEfilename, can use perror
  10 = Error allocating memory, there's no more memory
  11 = Error reading streams files
  12 = Error reading stream_list, it's broken
*/
int OLEcode (const char * OLEfilename, int trunc, pps_entry * stream_list, U32 root);


#ifdef __cplusplus
}
#endif

#endif /* OLECOD_H */

