/*
   cole - A free C OLE library.
   Sample using cole
   Copyright 1998, 1999  Roberto Arturo Tena Sanchez

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published  by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
/*
   Roberto Arturo Tena Sanchez <arturo@directmail.org>
 */


#include <stdio.h>

#include <oledecod.h>
#include <olecod.h>


int
main (int argc, char **argv)
{
  int result;
  pps_entry *stream_tree;
  U32 root_stream;
  U32 stream;


  if (argc != 3)
    {
      fprintf (stderr, "cole demo. cole is a free C OLE library.\nUsage: demo srcFILE destFILE.\nNote: if srcFILE and destFILE are the same file, it will be overwritten.\n");
      return 1;
    }


  verbose ("Decoding ************************************");
  result = OLEdecode (argv[1], &stream_tree, &root_stream, 0);


  fprintf (stderr, "OLEdecode output = %d\n", result);
  if (result != 0)
    {
      fprintf (stderr, "Decoding: ");
      perror (argv[1]);
      return 1;
    }
  else
    verbose ("Success decoding");


  printf ("******* Stream tree:\n");
  verbosePPSTree (stream_tree, root_stream, 0);


  printf ("******* Top level no directory streams:\n");
  /* travel through the top level no directory streams,
     just follows next field and ignore type 1 fileds */
  for (stream = stream_tree[root_stream].dir;
       stream != 0xffffffff;
       stream = stream_tree[stream].next)
    {
      if (stream_tree[stream].type != 1 && stream_tree[stream].level == 1)
      if (!isprint(stream_tree[stream].name[0]))
	printf ("'\\x%02x%s'\n", stream_tree[stream].name[0], stream_tree[stream].name+1);
      else
	printf ("'%s'\n", stream_tree[stream].name);
    }

  verbose ("Coding **************************************");
  result = OLEcode (argv[2], 1, stream_tree, root_stream);
  fprintf (stderr, "OLEcode output = %d\n", result);
  if (result != 0)
    {
      fprintf (stderr, "Coding ");
      perror (argv[2]);
      return 1;
    }
  else
    verbose ("Success coding\n");


  verbose ("Freeing *************************************");
  /* need to free all the allocated memory */
  result = freeOLEtree (stream_tree);
  fprintf (stderr, "freeOLEtree output = %d\n", result);

  return result;
}
