// cstreamable.h
//
//	A class to derive from to enable stream i/o. Does common things like
// overloading << and >> for itself and calling Read and Write functions.
//

#ifndef CSTREAMABLE_H
#define CSTREAMABLE_H

#include <iobstream.h>
#include <sys/types.h>

class CStreamable {
public:
    virtual size_t		SavedSize (void) const;
    virtual void		Read (istream& is);
    virtual void		Read (ibstream& is);
    virtual void		Write (ostream& os) const;
    virtual void		Write (obstream& os) const;
};

//-----------------------------------------------------------------------------

inline istream& operator>> (istream& is, CStreamable& obj)
{
    obj.Read (is);
    return (is);
}

inline ostream& operator<< (ostream& os, const CStreamable& obj)
{
    obj.Write (os);
    return (os);
}

inline ibstream& operator>> (ibstream& is, CStreamable& obj)
{
    obj.Read (is);
    return (is);
}

inline obstream& operator<< (obstream& os, const CStreamable& obj)
{
    obj.Write (os);
    return (os);
}

//-----------------------------------------------------------------------------

#endif

