// csocksvr.h
//
//	Defines a socket stream class.
//

#ifndef CSOCKSVR_H
#define CSOCKSVR_H

#ifdef BINARY_SOCKET_SERVER
    #include <sockstream.h>
#else
    #include <sockstream.h>
#endif

class CSocketServer {
public:
			CSocketServer (void);
    int			Open (int port, int socktype = AF_INET, 
			      int strtype = SOCK_STREAM);
    virtual void	Run (void);
    virtual void	UserServerProc (void) = 0;
    inline void		EnableForking (void);
    virtual void	Close (void);
    virtual	       ~CSocketServer (void);

protected:
    #ifdef BINARY_SOCKET_SERVER
    bsockstream		m_Socket;
    #else
    sockstream		m_Socket;
    #endif

private:
    bool		m_IsForking;
    struct sockaddr_in	m_SockAddr;
    struct hostent *	m_Host;
    int			m_SocketType;
    int			m_StreamType;
    int			m_SockId;
    int			m_Port;
};

//--------------------------------------------------------------------------

inline void CSocketServer :: EnableForking (void)
{
    m_IsForking = true;
}

#endif

