// csocksvr.cc
//
//	Implementation of the socket server class.
//

#include <sys/param.h>
#include <string.h>
#include <sys/socket.h>
#include <signal.h>
#include <netdb.h>
#include <unistd.h>
#include <wait.h>
#include <errno.h>
#include "csocksvr.h"

CSocketServer :: CSocketServer (void)
{
    m_SockId = -1;
    memset (&m_SockAddr, 0, sizeof(struct sockaddr_in));
    m_Host = NULL;
    m_SocketType = AF_INET;
    m_StreamType = SOCK_STREAM;
    m_Port = 0;
    m_IsForking = false;
}

int CSocketServer :: Open (int port, int socktype, int strtype)
{
char myname [MAXHOSTNAMELEN+1];

    m_Port = port;
    m_SocketType = socktype;
    m_StreamType = strtype;

    memset (&m_SockAddr, 0, sizeof(struct sockaddr_in));
    gethostname (myname, MAXHOSTNAMELEN);

    if ((m_Host = gethostbyname (myname)) == NULL)
	return (-1);

    m_SockAddr.sin_family = m_Host->h_addrtype;
    m_SockAddr.sin_port = htons (m_Port);

    if ((m_SockId = socket (m_SocketType, m_StreamType, 0)) < 0)
       	return (-2);

    if (bind (m_SockId, (struct sockaddr*) &m_SockAddr, 
	      sizeof(struct sockaddr_in)) < 0) 
    {
       	close (m_SockId);
       	return (-3);
    }

    return (0);
}

void CSocketServer :: Close (void)
{
    close (m_SockId);
}

static void Fireman (int child)
{
    child = -1;
    while (waitpid (-1, NULL, WNOHANG));
}

void CSocketServer :: Run (void)
{
int t;

    if (m_IsForking) {
	// Tell fireman to watch for falling children
	signal (SIGCHLD, Fireman);	
    }

    // Say we are ready
    listen (m_SockId, 5);

    // Loop forever waiting for connections
    while (1) { 
	if ((t = accept (m_SockId, NULL, NULL)) < 0) {
	    if (errno == EINTR)
		continue; 
	    perror ("CSocketServer accept");
	    return;
	} 

	if (m_IsForking) { 
	    switch (fork()) {
		case -1:
		    perror ("fork");
		    close (m_SockId);
		    close (t);
		    return;
		case 0:
		    close (m_SockId);
		    // No need to restore it, since this process will exit
		    m_Socket.attach (t);
		    UserServerProc();
		    m_Socket.attach (EOF);	// Closed
		    close (t);
		    exit (0);
		default:
		    close (t);
		    break;
	    }
	}
	else {
	    m_Socket.attach (t);
	    UserServerProc();
	    m_Socket.attach (EOF);	// Closed
	    close (t);
	}
    }
}

CSocketServer :: ~CSocketServer (void)
{
}

