// sockstreambase.h
//
//	Socket stream base functionality.
//

#ifndef SOCKSTREAMBASE_H
#define SOCKSTREAMBASE_H

#include "sockbuf.h"

class sockstreambase : virtual public ios {
private:
#ifdef _IO_NEW_STREAMS
    sockbuf		__my_sb;
#endif
    void		__sb_init (void);

public:
    			sockstreambase (void);
    			sockstreambase (int sfd);
    			sockstreambase (const char* hostname, port_t port,
    				int socktype = SOCK_STREAM, 
				int streamtype = AF_INET);
    inline void 	close (void);
    inline void 	open (const char* hostname, port_t port,
    				int socktype = SOCK_STREAM, 
				int streamtype = AF_INET);
    inline int 		is_open (void) const;
    inline void 	setbuf (char *ptr, int len);
    inline void 	attach (int fd);
#ifdef _IO_NEW_STREAMS
    inline sockbuf* 	rdbuf (void) const;
#else
    inline sockbuf* 	rdbuf (void) const;
#endif
#ifdef _STREAM_COMPAT
    int 		filedesc (void);
    sockstreambase& 	raw (void);
#endif
};

//-----------------------------------------------------------------------------

inline sockbuf* sockstreambase :: rdbuf (void) const
{
    #ifdef _IO_NEW_STREAMS
	return ((sockbuf*) &__my_sb);
    #else
        return ((sockbuf*) ios::rdbuf());
    #endif
}

inline int sockstreambase :: is_open (void) const
{
    return (rdbuf()->is_open());
}

inline void sockstreambase :: setbuf (char *ptr, int len)
{
    rdbuf()->setbuf (ptr, len);
}

inline void sockstreambase :: attach (int fd)
{
    if (!rdbuf()->attach (fd))
	set (ios::failbit);
}

inline void sockstreambase :: close (void)
{
    if (!rdbuf()->close())
	set (ios::failbit);
}

inline void sockstreambase :: open 
(const char* hostname, port_t port, int socktype, int streamtype)
{
    clear();
    if (!rdbuf()->open (hostname, port, socktype, streamtype))
	set (ios::badbit);
}

#ifdef _STREAM_COMPAT
inline int sockstreambase :: filedesc (void)
{
    return (rdbuf()->fd());
}

sockstreambase& sockstreambase :: raw (void)
{
    rdbuf()->setbuf (NULL, 0);
    return (*this);
}
#endif

//-----------------------------------------------------------------------------

#endif

