// sockstreambase.h
//
//	Socket stream base functionality.
//

#include "sockstreambase.h"

sockstreambase :: sockstreambase (void)
{
    __sb_init();
}

sockstreambase :: sockstreambase (int sfd)
{
    __sb_init();
    attach (sfd);
}

sockstreambase :: sockstreambase
(const char* hostname, port_t port, int socktype, int streamtype)
{
    __sb_init();
    open (hostname, port, socktype, streamtype);
}

void sockstreambase :: __sb_init (void)
{
    #ifdef _IO_NEW_STREAMS
	init (&__my_sb);
    #else
    	init (new sockbuf);
	_flags &= ~ios::dont_close;
    #endif
}

