// sockbuf.h
//
//	Derivation from streambuf to allow streams over BSD sockets.
//

#ifndef SOCKSTREAMBUF_H
#define SOCKSTREAMBUF_H

#include <streambuf.h>
#include <sys/socket.h>
#include <netinet/in.h>

typedef int		socket_t;
typedef short int	port_t;

class sockbuf : public streambuf {
public:
			sockbuf (void);
			sockbuf (const socket_t& sfd);
			sockbuf (const char* hostname, port_t port,
    				int socktype = SOCK_STREAM, 
				int streamtype = AF_INET);
    streambuf * 	setbuf (char *p, int len);
    sockbuf *		attach (const socket_t& sfd);
    sockbuf *		open (const char* hostname, port_t port, 
    				int socktype = SOCK_STREAM, 
				int streamtype = AF_INET);
    sockbuf *		close (void);
    inline int		is_open (void) const;
    inline socket_t	fd (void) const;
    virtual int		sync (void);
    virtual int		underflow (void);
    virtual int		overflow (int ch);
    streamsize		xsputn (const char* text, streamsize n);
    streamsize		xsgetn (char* text, streamsize n);
    virtual	       ~sockbuf (void);

protected:
    virtual streamsize	sys_read (char* buf, streamsize size);
    virtual streamsize	sys_write (const char* buf, streamsize size);

private:
    socket_t		m_sfd;
    streamsize		m_bcount; // Number of bytes transferred on last op
    char *		m_commbuf;	// Character cache
};

//----------------------------------------------------------------------

inline int sockbuf :: is_open (void) const
{
    return (m_sfd == EOF);
}

inline socket_t	sockbuf :: fd (void) const
{
    return (m_sfd);
}

//----------------------------------------------------------------------

#endif

