// obstrstream.h
//
//	obstrstream = Output Binary String Stream
//	A binary >> alternative to ostrstream, derived from obstream.
//

#ifndef OBSTRSTREAM_H
#define OBSTRSTREAM_H

#include <obstream.h>
#include <strstream.h>

class obstrstream : public strstreambase, public obstream {
public:
    			obstrstream (void);
    			obstrstream (char *cp, int n, int mode = ios::out);
    inline _IO_ssize_t 	pcount (void);
    inline char *	str (void);
    inline void		freeze (int n = 1);
    inline int 		frozen (void);
};

//-----------------------------------------------------------------------------

inline _IO_ssize_t obstrstream :: pcount (void)
{ 
    return ((strstreambuf*)_strbuf)->pcount();
}

inline char * obstrstream :: str (void) 
{
    return ((strstreambuf*)_strbuf)->str();
}

inline void obstrstream :: freeze (int n) 
{
    ((strstreambuf*)_strbuf)->freeze(n);
}

inline int obstrstream :: frozen (void) 
{
    return ((strstreambuf*)_strbuf)->frozen();
}

//-----------------------------------------------------------------------------

#endif

