// obstream.h
//
//	obstream = Output Binary Stream
//	A derivation from ostream to change << to save binary data.
// Aside from those operators no other functions need to be changed as
// they already save data in binary (like gets, reads, etc.)
//	There is an unfortunate side effect of hiding all non-overloaded
// operators << because they are declared as non=virtual in istream.
//

#ifndef OBSTREAM_H
#define OBSTREAM_H

#include <iostream.h>
#include <sys/types.h>
#ifndef BSTREAMS_NATIVE_BO
    #include <netinet/in.h>
#endif

class obstream : public ostream {
public:
    				obstream (void);
				obstream (streambuf* sb, ostream* tied = NULL);
    obstream& 			operator<< (const unsigned char*);
    inline obstream& 		operator<< (const signed char*);
    inline obstream& 		operator<< (const char*);
    inline obstream& 		operator<< (char);
    inline obstream& 		operator<< (signed char);
    inline obstream& 		operator<< (unsigned char);
    inline obstream& 		operator<< (signed int);
    inline obstream& 		operator<< (signed long);
    inline obstream& 		operator<< (signed short);
    inline obstream&	 	operator<< (unsigned int);
    inline obstream& 		operator<< (unsigned long);
    inline obstream& 		operator<< (unsigned short);
#if _G_HAVE_BOOL
    inline obstream& 		operator<< (bool);
#endif
    inline obstream& 		operator<< (float);
    inline obstream& 		operator<< (double);
    inline obstream& 		operator<< (long double);

    virtual void		WriteStringSize (size_t sizeToWrite);
};

//-----------------------------------------------------------------------------

inline obstream& obstream :: operator<< (const signed char* val)
{
    return (operator<< ((const unsigned char*) val));
}

inline obstream& obstream :: operator<< (const char* val)
{
    return (operator<< ((const unsigned char*) val));
}

inline obstream& obstream :: operator<< (signed char val)
{
    write ((const void*) &val, sizeof(signed char));
    return (*this);
}

inline obstream& obstream :: operator<< (char val)
{
    write ((const void*) &val, sizeof(char));
    return (*this);
}

inline obstream& obstream :: operator<< (unsigned char val)
{
    write ((const void*) &val, sizeof(unsigned char));
    return (*this);
}

inline obstream& obstream :: operator<< (signed int val)
{
    #ifdef BSTREAMS_NATIVE_BO
	write ((const void*) &val, sizeof(signed int));
    #else
	unsigned long nval = htonl (val);
	write ((const void*) &nval, sizeof(unsigned long));
    #endif
    return (*this);
}

inline obstream& obstream :: operator<< (signed long val)
{
    #ifdef BSTREAMS_NATIVE_BO
	write ((const void*) &val, sizeof(signed long));
    #else
	unsigned long nval = htonl (val);
	write ((const void*) &nval, sizeof(unsigned long));
    #endif
    return (*this);
}

inline obstream& obstream :: operator<< (signed short val)
{
    #ifdef BSTREAMS_NATIVE_BO
	write ((const void*) &val, sizeof(signed short));
    #else
	unsigned short nval = htons (val);
	write ((const void*) &nval, sizeof(unsigned short));
    #endif
    return (*this);
}

inline obstream& obstream :: operator<< (unsigned int val)
{
    #ifdef BSTREAMS_NATIVE_BO
	write ((const void*) &val, sizeof(unsigned int));
    #else
	unsigned long nval = htonl (val);
	write ((const void*) &nval, sizeof(unsigned long));
    #endif
    return (*this);
}

inline obstream& obstream :: operator<< (unsigned long val)
{
    #ifdef BSTREAMS_NATIVE_BO
	write ((const void*) &val, sizeof(unsigned long));
    #else
	unsigned long nval = htonl (val);
	write ((const void*) &nval, sizeof(unsigned long));
    #endif
    return (*this);
}

inline obstream& obstream :: operator<< (unsigned short val)
{
    #ifdef BSTREAMS_NATIVE_BO
	write ((const void*) &val, sizeof(unsigned short));
    #else
	unsigned short nval = htons (val);
	write ((const void*) &nval, sizeof(unsigned short));
    #endif
    return (*this);
}

#if _G_HAVE_BOOL
inline obstream& obstream :: operator<< (bool val)
{
    #ifdef BSTREAMS_NATIVE_BO
	write ((const void*) &val, sizeof(bool));
    #else
	unsigned char charCast = (unsigned char) val;
	write ((const void*) &charCast, sizeof(unsigned char));
    #endif
    return (*this);
}
#endif

inline obstream& obstream :: operator<< (float val)
{
    write ((const void*) &val, sizeof(float));
    return (*this);
}

inline obstream& obstream :: operator<< (double val)
{
    write ((const void*) &val, sizeof(double));
    return (*this);
}

inline obstream& obstream :: operator<< (long double val)
{
    write ((const void*) &val, sizeof(long double));
    return (*this);
}

//-----------------------------------------------------------------------------

#endif

