// obstream.cc
//
//	obstream = Output Binary Stream
//	A derivation from ostream to change << to save binary data.
// Aside from those operators no other functions need to be changed as
// they already save data in binary (like gets, reads, etc.)
//	There is an unfortunate side effect of hiding all non-overloaded
// operators << because they are declared as non=virtual in istream.
// That means no manipulators (you shouldn't use them anyway for binary data)
//	and no void* type (how the hell do you save a void* type???)
//

#include "obstream.h"
#include <limits.h>
#include <sys/types.h>

obstream :: obstream (void)
{
}

obstream :: obstream (streambuf* sb, ostream* tied)
: ostream (sb, tied)
{
}

void obstream :: WriteStringSize (size_t sizeToWrite)
{
    unsigned char strSizeSmall = UCHAR_MAX;
    unsigned short strSizeMedium = USHRT_MAX;
    unsigned long strSizeLarge = 0;

    if (sizeToWrite < UCHAR_MAX)
	strSizeSmall = sizeToWrite;
    write (&strSizeSmall, sizeof(unsigned char));

    if (sizeToWrite >= UCHAR_MAX) {
	if (sizeToWrite < USHRT_MAX)
	    strSizeMedium = sizeToWrite;
	operator<< (strSizeMedium);
	
	if (sizeToWrite >= USHRT_MAX) {
	    strSizeLarge = ntohl (sizeToWrite);
	    operator<< (strSizeLarge);
	}
    }
}

obstream& obstream :: operator<< (const unsigned char* str)
{
    size_t strSize = strlen ((const char*) str);
    WriteStringSize (strSize);
    write (str, strSize * sizeof(char));
    return (*this);
}

