// ibstriter.h
//
//	Parallel to istream_iterator for ibstream
//

#ifndef IBSTRITER_H
#define IBSTRITER_H

template <class T, class Distance = ptrdiff_t>
class ibstream_iterator : public input_iterator<T, Distance> {
public:
    inline					ibstream_iterator (void);
    inline					ibstream_iterator (ibstream& s);
    inline const T& 				operator* (void) const;
    inline ibstream_iterator<T, Distance>&	operator++ (void);
    inline ibstream_iterator<T, Distance>	operator++ (int);

protected:
    inline void 	read (void);

protected:
    ibstream*		stream;
    T			value;
    bool		end_marker;

private:
    friend bool		operator== (const ibstream_iterator<T, Distance>& x,
    				const ibstream_iterator<T, Distance>& y);
};

//-----------------------------------------------------------------------------

// Arghh!!! This is UGLY!

template <class T, class Distance = ptrdiff_t>
inline ibstream_iterator<T, Distance> :: ibstream_iterator (void)
{
}

template <class T, class Distance = ptrdiff_t>
inline ibstream_iterator<T, Distance> :: ibstream_iterator(ibstream& s)
: stream (&s)
{
    read();
}

template <class T, class Distance = ptrdiff_t>
inline const T& ibstream_iterator<T, Distance> :: operator* (void) const
{
    return value;
}

template <class T, class Distance = ptrdiff_t>
inline ibstream_iterator<T, Distance>& ibstream_iterator<T, Distance> ::
operator++ (void)
{
    read();
    return *this;
}

template <class T, class Distance = ptrdiff_t>
inline ibstream_iterator<T, Distance> ibstream_iterator<T, Distance> ::
operator++ (int)
{
    ibstream_iterator<T, Distance> tmp = *this;
    read();
    return tmp;
}

template <class T, class Distance = ptrdiff_t>
inline void ibstream_iterator<T, Distance> :: read (void)
{
    end_marker = (*stream) ? true : false;
    if (end_marker) *stream >> value;
	end_marker = (*stream) ? true : false;
}

//-----------------------------------------------------------------------------

template <class T, class Distance = ptrdiff_t>
bool operator==
(const ibstream_iterator<T, Distance>& x, 
 const ibstream_iterator<T, Distance>& y)
{
    return (x.stream == y.stream &&
    	    x.end_marker == y.end_marker ||
	    x.end_marker == false && 
	    y.end_marker == false);
}

//-----------------------------------------------------------------------------

#endif


