// ibstream.h
//
//	ibstream = Input Binary Stream
//	A derivation from istream to change >> to save binary data.
// Aside from those operators no other functions need to be changed as
// they already save data in binary (like gets, reads, etc.)
//	There is an unfortunate side effect of hiding all non-overloaded
// operators >> because they are declared as non=virtual in istream.
//

#ifndef IBSTREAM_H
#define IBSTREAM_H

#include <iostream.h>
#include <sys/types.h>
#ifndef BSTREAMS_NATIVE_BO
    #include <netinet/in.h>
#endif

class ibstream : public istream {
public:
    				ibstream (void);
				ibstream (streambuf* sb, ostream* tied = NULL);
    ibstream& 			operator>> (unsigned char*);
    inline ibstream& 		operator>> (signed char*);
    inline ibstream& 		operator>> (char*);
    inline ibstream& 		operator>> (char& c);
    inline ibstream& 		operator>> (signed char& c);
    inline ibstream& 		operator>> (unsigned char& c);
    inline ibstream& 		operator>> (signed int&);
    inline ibstream& 		operator>> (signed long&);
    inline ibstream& 		operator>> (signed short&);
    inline ibstream& 		operator>> (unsigned int&);
    inline ibstream& 		operator>> (unsigned long&);
    inline ibstream& 		operator>> (unsigned short&);
#if _G_HAVE_BOOL
    inline ibstream& 		operator>> (bool&);
#endif
    inline ibstream& 		operator>> (float&);
    inline ibstream& 		operator>> (double&);
    inline ibstream& 		operator>> (long double&);

    virtual size_t		ReadStringSize (void);
};

//-----------------------------------------------------------------------------

inline ibstream& ibstream :: operator>> (signed char* val)
{
    return (operator>> ((unsigned char*) val));
}

inline ibstream& ibstream :: operator>> (char* val)
{
    return (operator>> ((unsigned char*) val));
}

inline ibstream& ibstream :: operator>> (signed char& val)
{
    read (&val, sizeof(signed char));
    return (*this);
}

inline ibstream& ibstream :: operator>> (char& val)
{
    read (&val, sizeof(char));
    return (*this);
}

inline ibstream& ibstream :: operator>> (unsigned char& val)
{
    read (&val, sizeof(unsigned char));
    return (*this);
}

inline ibstream& ibstream :: operator>> (signed int& val)
{
    #ifdef BSTREAMS_NATIVE_BO
	read (&val, sizeof(signed int));
    #else
	unsigned long nval;
	read (&nval, sizeof(unsigned long));
	val = (signed int) ntohl (nval);
    #endif
    return (*this);
}

inline ibstream& ibstream :: operator>> (signed long& val)
{
    #ifdef BSTREAMS_NATIVE_BO
	read (&val, sizeof(signed long));
    #else
	unsigned long nval;
	read (&nval, sizeof(unsigned long));
	val = (signed long) ntohl (nval);
    #endif
    return (*this);
}

inline ibstream& ibstream :: operator>> (signed short& val)
{
    #ifdef BSTREAMS_NATIVE_BO
	read (&val, sizeof(signed short));
    #else
	unsigned short nval;
	read (&nval, sizeof(unsigned short));
	val = (signed short) ntohs (nval);
    #endif
    return (*this);
}

inline ibstream& ibstream :: operator>> (unsigned int& val)
{
    #ifdef BSTREAMS_NATIVE_BO
	read (&val, sizeof(unsigned int));
    #else
	unsigned long nval;
	read (&nval, sizeof(unsigned long));
	val = (unsigned int) ntohl (nval);
    #endif
    return (*this);
}

inline ibstream& ibstream :: operator>> (unsigned long& val)
{
    #ifdef BSTREAMS_NATIVE_BO
	read (&val, sizeof(unsigned long));
    #else
	unsigned long nval;
	read (&nval, sizeof(unsigned long));
	val = ntohl (nval);
    #endif
    return (*this);
}

inline ibstream& ibstream :: operator>> (unsigned short& val)
{
    #ifdef BSTREAMS_NATIVE_BO
	read (&val, sizeof(unsigned short));
    #else
	unsigned short nval;
	read (&nval, sizeof(unsigned short));
	val = ntohs (nval);
    #endif
    return (*this);
}

#if _G_HAVE_BOOL
inline ibstream& ibstream :: operator>> (bool& val)
{
    #ifdef BSTREAMS_NATIVE_BO
	read (&val, sizeof(bool));
    #else
	unsigned char charCast;
	read (&charCast, sizeof(unsigned char));
	val = (bool) charCast;
    #endif
    return (*this);
}
#endif

inline ibstream& ibstream :: operator>> (float& val)
{
    read (&val, sizeof(float));
    return (*this);
}

inline ibstream& ibstream :: operator>> (double& val)
{
    read (&val, sizeof(double));
    return (*this);
}

inline ibstream& ibstream :: operator>> (long double& val)
{
    read (&val, sizeof(long double));
    return (*this);
}

//-----------------------------------------------------------------------------

#endif

