// ibstream.cc
//
//	ibstream = Input Binary Stream
//	A derivation from istream to change >> to save binary data.
// Aside from those operators no other functions need to be changed as
// they already save data in binary (like gets, reads, etc.)
//	There is an unfortunate side effect of hiding all non-overloaded
// operators >> because they are declared as non=virtual in istream.
//

#include "ibstream.h"
#include <limits.h>
#include <sys/types.h>

ibstream :: ibstream (void)
{
}

ibstream :: ibstream (streambuf* sb, ostream* tied)
: istream (sb, tied)
{
}

size_t ibstream :: ReadStringSize (void)
{
    register size_t strSize;
    unsigned char strSizeSmall = 0;
    unsigned short strSizeMedium = 0;
    unsigned long strSizeLarge = 0;

    read (&strSizeSmall, sizeof(unsigned char));
    if (strSizeSmall == UCHAR_MAX) {
	operator>> (strSizeMedium);
	if (strSizeMedium == USHRT_MAX) {
	    operator>> (strSizeLarge);
	    strSize = strSizeLarge;
	}
	else
	    strSize = strSizeMedium;
    }
    else
	strSize = strSizeSmall;

    return (strSize);
}

ibstream& ibstream :: operator>> (unsigned char* str)
{
    size_t strSize = ReadStringSize();
    if (strSize > 0)
	read (str, strSize * sizeof(char));
    return (*this);
}

