#include <ofbstream.h>

//
// Using ostream pointers and references will not work:
//
// void write_data (int numdat, const char* strdat, ostream& os)
//
// because the << operators are not virtual. Use obstream as the base:
//
void write_data (int numdat, const char* strdat, obstream& os)
{
    os << numdat << strdat;
}

int main (int, char**)
{
    int num1 = 1000;
    ofbstream os;
    os.open ("file.dat");
    const char str1 [] = "This is a string of size 29";
    write_data (num1, str1, os);
    os.flush();
    os.close();
    return (0);
}

