// ibstrstream.h
//
//	bstrstream = Binary String Stream
//	A binary << and >> alternative to strstream, derived from iobstream.
//

#ifndef BSTRSTREAM_H
#define BSTRSTREAM_H

#include <iobstream.h>
#include <strstream.h>

class bstrstream : public strstreambase, public iobstream {
public:
			bstrstream (void);
			bstrstream (char *cp, int n, int mode = ios::out);
    inline _IO_ssize_t 	pcount (void);
    inline char *	str (void);
    inline void 	freeze (int n = 1);
    inline int 		frozen (void);
};

//-----------------------------------------------------------------------------

inline _IO_ssize_t bstrstream :: pcount (void)
{
    return ((strstreambuf*)_strbuf)->pcount();
}

inline char * bstrstream :: str (void)
{
    return ((strstreambuf*)_strbuf)->str();
}

inline void bstrstream :: freeze (int n)
{
    ((strstreambuf*)_strbuf)->freeze(n);
}

inline int bstrstream :: frozen (void)
{
    return ((strstreambuf*)_strbuf)->frozen();
}

//-----------------------------------------------------------------------------

#endif

