# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..3\n"; }
END {
 print "not ok 1\n\n" unless $loaded;
 print "not ok 2\n\n" unless $perlbinOK;
 print "not ok 3\n\n" unless $found_rcfile;
}
use PLC;
$loaded = 1;
print "ok 1\n\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

$perlbinOK = 0;
print "2..3\n";

use Config;
my $perlbin = substr($Config::Config{'startperl'},2);
if ($perlbin) {
 $perlbinOK = 1;
 print "Perl is located at $perlbin\n";
 if ($perlbin =~ '^/usr/bin/perl') {
  print "No need to change shebang line in example scripts in 'executables'\n";
 }
 else {
  print "Attempting to fix shebang line in executables/* ...\n";
  for (<./executables/*>) {
   next if -d $_; # skip subdirectories
   open(FILE, "$_") && (@lines = <FILE>) or $perlbinOK = 0;
   close (FILE);
   if ( ($lines[0] =~ s/^#!\/.*\/perl/#!$perlbin/)
   && open(FILE, ">$_") ) {
    print "Fixing perl path in shebang line of $_\n";
    print FILE @lines;
    close (FILE);
   }
   else {
    $perlbinOK = 0;
   }
  }
 }
}
if ($perlbinOK) {
 print "ok 2\n\n";
}
else {
 print "You may need to edit the first line of the example programs\n";
 print "to make the perl path \'$perlbin\'\n";
}


$found_rcfile = 0;
print "3..3\n";

if ( ! -d '/plc/' ) {
 print "\a\nCan't find directory /plc/, did you create it? See README\n\n";
}
elsif ( ! -r '/plc/' ) {
 print "\a\nCan't read directory /plc/, check permissions, See README\n\n";
}
elsif ( ! -f "/plc/PLCproc.rc" ) {
 print "\a\nCan't find /plc/PLCproc.rc, and I need it! See README\n\n";
}
elsif ( ! -r "/plc/PLCproc.rc" ) {
 print "\a\nCan't read /plc/PLCproc.rc, check permissions, See README\n\n";
}
else {
 $found_rcfile = 1;
 print "ok 3\n\n";
}
unless ($found_rcfile) {
 print <<EOT

You need to create the directory /plc and copy the example file PLCproc.rc
into /plc, then edit /plc/PLCproc.rc with information regarding your PLC's.

See README and QUICKSTART files for more information.

EOT
}

