//==========================================================================
//
//   algorithm.h 
//
//==========================================================================
// $Id: algorithm.h,v 1.10 2000/01/05 16:32:32 raitner Exp $

#ifndef GTL_ALGORITHM_H
#define GTL_ALGORITHM_H

#include <GTL/GTL.h>
#include <GTL/graph.h>

__GTL_BEGIN_NAMESPACE

/**
 * @short Abstract baseclass for all algoritm-classes.
 */
class GTL_EXTERN algorithm {
public:

    /**
     * error values returned by algorithms in run and check.
     * 
     * @see algorithm#run
     * @see algorithm#check
     */
    enum {
	GTL_OK = 1,
	GTL_ERROR = 0
    };

    /**
     * Creates an algorithm object.
     */
    algorithm () { };
    
    /**
     * Destroys the algorithm object.
     */
    virtual ~algorithm () { };    

    /**
     * Applies algorithm to graph <code>g</code>. 
     * <em>Please note:</em> It is definitly required (and 
     * <code>run</code> relies on it), that <code>check</code> was 
     * called in advance. 
     * 
     * @param <code>G</code> graph
     * @return <code>algorithm::GTL_OK</code> on success 
     * <code>algorithm::GTL_ERROR</code>
     * otherwise 
     * @see algorithm#check
     */
    virtual int run (graph& g) = 0;
    
    /**
     * Checks whether all preconditions are satisfied.
     * 
     * @param <code>G</code> graph
     * @return <code>algorithm::GTL_OK</code> on success 
     * <code>algorithm::GTL_ERROR</code>
     * otherwise 
     */
    virtual int check (graph& g) = 0;
    
    /**
     * Resets algorithm, i.e. prepares the algorithm to be applied to
     * another graph. <em>Please note:</em> The options an
     * algorithm may support do <em>not</em> get reset by
     * this. It is just to reset internally used datastructures.
     */
    virtual void reset () = 0;
};

__GTL_END_NAMESPACE

#endif // GTL_ALGORITHM_H

//--------------------------------------------------------------------------
//   end of file
//--------------------------------------------------------------------------
