#!/bin/sh
#
# UPgrade-in-a-box made and tested by Jerome G. on Linux 1.2.13
# UPgrade your box to Linux 2.0.29 ...
################################################################################
# Copyright 1997 by Jerome G. <jerome@cnd.net>                                 #
# All Rights Reserved.                                                         #
#                                                                              #
# Permission to use, copy, modify, and distribute this software and its        #
# documentation for any purpose and without fee is hereby granted, provided    #
# that the above copyright notice appear in all copies and that both that      #
# copyright notice and this permission notice appear in supporting             #
# documentation, and that the name of the above listed copyright holder(s) not #
# be used in advertising or publicity pertaining to distribution of the        #
# software without specific, written prior permission. THE ABOVE LISTED        #
# COPYRIGHT HOLDER(S) DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,    #
# INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT #
# SHALL THE ABOVE LISTED COPYRIGHT HOLDER(S) BE LIABLE FOR ANY SPECIAL,        #
# INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM   #
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE   #
# OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR    #
# PERFORMANCE OF THIS SOFTWARE.                                                #
################################################################################
PATH=.:/bin:/usr/bin:/usr/local/bin:sbin:/usr/sbin:${HOME}:${PATH}:/:/upgrade-in-a-box ; export PATH
#
clear;
#
echo " =-= ---------------------------------------------- =-= "
echo "      ***  Welcome To Upgrade-In-A-Box v2.29  ***"
echo " "
echo "     This src was made for upgrading your linux box"
echo "     from ver. 1.2.X to 2.0.29 .... [ 02/09/97 ] .."
echo "     by: Jerome G.  E-mail: jerome@cnd.net for help"
echo " =-= ---------------------------------------------- =-= "
echo "     NOTE: Tested on SlackWare Distributions.......     "
echo " =-= ---------------------------------------------- =-= "
sleep 20;
echo " *** The list below show you all the programs/libs, *** "
echo " *** System tools/Utils that will be upgraded etc.. *** "
echo " =-= ---------------------------------------------- =-= "
sleep 5;
echo " "
echo " 01) libc-5.4.17.bin.tar.gz	1,026,184 "
echo " 02) libg++-2.7.2.1.bin.tar.gz	1,271,340 "
echo " 03) make-3.75.tar.gz		  167,018 "
echo " 04) ncurses-1.9.9e.bin.tar.gz	1,088,530 "
echo " 05) db-1.85.4-bin-ELF.tar.gz	   68,576 "
echo " 06) binutils-2.7.0.3.bin.tar.gz	2,208,912 "
echo " 07) gcc-2.7.2.1.bin.tar.gz	4,262,743 "
echo " 08) e2fsprogs-1.06-elfbin.tar.gz	  206,614 "
echo " 09) termcap-2.0.8.tar.gz		  268,187 "
echo " 10) ld.so-1.8.5.tar.gz		  282,786 "
echo " 11) linux-2.0.29.tar.gz		6,069,597 "
echo "                                 ---------- "
echo "                          Total: 16,921,511 "
echo " =-= ---------------------------------------------- =-= "
echo " NOTE: All the above files came from (sunsite.unc.edu)  "
echo " NOTE: YOU MUST BE ROOT TO UPGRADE YOUR SYSTEM.....     "
echo " =-= ---------------------------------------------- =-= "
echo " "
echo " [Press Ctrl+C to Quit] or [wait 10s to Upgrade NOW]    "
sleep 35;
#
# Un-compress upgrade-kit-2.29.tar.gz and install upgrade in a box
mkdir /upgrade-in-a-box
cp upgrade /upgrade-in-a-box
cp upgrade.sh /upgrade-in-a-box
cp Files+sites.txt /upgrade-in-a-box
cp Changes-to-2.0.txt /upgrade-in-a-box
cp READ-ME-NOW /upgrade-in-a-box
cp ppp-2.2.0f.tar* /upgrade-in-a-box
mv clear /bin
mv sleep /bin
mv release.* /upgrade-in-a-box
mv ncurses-4.0.tgz /upgrade-in-a-box
mv upgrade-kit-2.29.tar.gz /;
cd /;
tar zxvf upgrade-kit-2.29.tar.gz
mv upgrade-kit-2.29.tar.gz /upgrade-in-a-box
# Done...
#
clear;
echo "================================================================================"
echo " "
echo "UP Grading... [ libc ]"
sleep 4;
cd /
rm -f /lib/libc.so /lib/libm.so
rm -f /usr/lib/libc.so /usr/lib/libm.so
rm -f /usr/include/iolibio.h /usr/include/iostdio.h
rm -f /usr/include/wcstr.h /usr/include/mbstr.h
rm -f /usr/include/ld_so_config.h /usr/include/localeinfo.h
rm -rf /usr/include/netinet /usr/include/net /usr/include/pthread
gzip -dc libc-5.4.17.bin.tar.gz | tar xvvf -
ldconfig;
#
clear;
echo "================================================================================"
echo " *** Installation complete for [ libc ] *** "
echo "================================================================================"
echo " "
echo "UP Grading... [ libg++ ]"
sleep 5;
cd /
rm -rf /usr/include/g++
gzip -dc libg++-2.7.2.1.bin.tar.gz | tar xvvf -
ldconfig /usr/lib
ldconfig
#
clear;
echo "================================================================================"
echo " *** Installation complete for [ libg++ ] *** "
echo "================================================================================"
echo " "
echo "UP Grading... [ make ]"
sleep 4;
cd /
tar xvfz make-3.75.tar.gz
cd make-3.75/;
mv make /bin;
mv /usr/bin/make /usr/bin/make.old;
cp /bin/make /usr/bin;
#
clear;
echo "================================================================================"
echo " *** Installation complete for [ make ] *** "
echo "================================================================================"
echo " "
echo "UP Grading... [ ncurses ]"
sleep 5;
cd /
rm -f /usr/include/ncurses
rm -f /usr/include/ncurses.h /usr/include/curses.h
rm -f /usr/lib/libcurses* /usr/lib/libmenu* /usr/lib/libpanel*
rm -f /usr/lib/libncurses* /lib/libncurses*
rm -f /usr/lib/libform*
rm -rf /usr/lib/terminfo
rm -rf /usr/bin/reset
rm -rf /usr/bin/tset
tar xvfz ncurses-1.9.9e.bin.tar.gz
ldconfig;
#
clear;
echo "================================================================================"
echo " *** Installation complete for [ ncurses ] *** "
echo "================================================================================"
echo " "
echo "UP Grading... [ db ] "
sleep 4;
cd /
tar xvfz db-1.85.4-bin-ELF.tar.gz
ldconfig;
#
clear;
echo "================================================================================"
echo " *** Installation complete for [ db ] *** "
echo "================================================================================"
echo " "
echo "UP Grading... [ binutils ] "
sleep 4;
cd /
tar xvfz binutils-2.7.0.3.bin.tar.gz
#
clear;
echo "================================================================================"
echo " *** Installation complete for [ binutils ] *** "
echo "================================================================================"
echo " "
echo "UP Grading... [ gcc ] "
sleep 4;
cd /
rm -rf /usr/bin/cpp 
rm -rf /lib/cpp
# gzip -dc gcc-2.7.2.1.bin.tar.gz | tar xvvf -
cd /
tar xvfz gcc-2.7.2.1.bin.tar.gz 
ln -s /usr/lib/gcc-lib/i486-linux/2.7.2.1/cpp /usr/bin/cpp
ln -s /usr/lib/gcc-lib/i486-linux/2.7.2.1/cpp /lib/cpp
ldconfig;
#
clear;
echo "================================================================================"
echo " *** Installation complete for [ gcc ] *** "
echo "================================================================================"
echo " "
echo "UP Grading... [ e2fsprogs ] "
sleep 4;
cd /
tar xvfz e2fsprogs-1.06-elfbin.tar.gz
install-utils/remove_preformat_manpages
install-utils/compile_manpages
cp install-utils/remove_preformat_manpages /bin
cp install-utils/compile_manpages /bin
rm -rf INSTALL
rm -rf README
rm -rf install-utils
ldconfig;
#
clear;
echo "================================================================================"
echo " *** Installation complete for [ e2fsprogs ] *** "
echo "================================================================================"
echo " "
echo "UP Grading... [ ld.so ]"
sleep 4;
cd /
tar xvfz ld.so-1.8.5.tar.gz
cd ld.so-1.8.5/
clear;
echo " "
echo " *** Press ENTER 2 Times -- Your System is NOW TRUE ELF *** "
sleep 6;
./instldso.sh
ldconfig;
clear;
cd /
rm -rf ld.so-1.8.5/;
#
clear;
echo "================================================================================"
echo " *** Installation complete for [ ld.so ] *** "
echo "================================================================================"
echo " "
echo "UP Grading... [ termcap ] "
sleep 4;
cd /
tar xvfz termcap-2.0.8.tar.gz
cd termcap-2.0.8/
make depend
make .depend
make
make install
cd /
rm -rf termcap-2.0.8/
#
clear;
echo "================================================================================"
echo " *** Installation complete for [ termcap ] *** "
echo "================================================================================"
sleep 4;
echo " "
echo "================================================================================"
echo " *** Ok.. You are 90% Done...   Time to install the big one :) "
echo " 1) If you have any thing in /usr/src/linux it will be backup "
echo "    as /usr/src/linux.backup "
echo " 2) Hope you have space for this :) "
echo " 3) You will need to config. the kernal, I will compile it "
echo " 4) The kernal out put will be (zImage) in /etc "
echo " 5) If you use (lilo) you will need to config. it for the new kernal "
echo " "
echo " NOTE: I hope you are on a PC .. 386/486/586 or 686 "
echo "       If NOT you will have to install the kernal your self [ Press Ctrl + ^C ] "
echo "================================================================================"
sleep 20;
mkdir /usr/src
mv /usr/src/linux /usr/src/linux.backup
mv linux-2.0.29.tar.gz /usr/src
cd /usr/src
tar xvfz linux-2.0.29.tar.gz
clear;
cd /usr/include
rm -rf asm linux scsi
ln -s /usr/src/linux/include/asm-i386 asm
ln -s /usr/src/linux/include/linux linux
ln -s /usr/src/linux/include/scsi scsi
clear;
echo " "
echo " Changing Dir. to /usr/src/linux "
echo " "
sleep 2;
cd /usr/src/linux
echo " *** Running --# make mrproper "
echo " "
make mrproper
echo "================================================================================"
echo " *** Running --# make menuconfig "
echo " "
echo " *** Please setup all the options - Then Exit"
echo "================================================================================"
sleep 8;
make menuconfig
clear;
echo "================================================================================"
echo " *** Running --# make dep "
echo " "
make dep
echo " *** Running --# make clean "
echo " "
make clean
echo " *** Running --# make zImage "
echo " "
make zImage
clear;
echo "================================================================================"
echo " *** Installation complete for [ Kernal 2.0.29 - zImage ] *** "
echo "================================================================================"
sleep 4;
echo " *** Running --# make modules "
echo " "
cd /usr/src/linux
make modules
echo " *** Running --# make modules_install"
echo " "
make modules_install
echo " "
mv /etc/zImage /etc/zImage.old;
echo " "
cp /usr/src/linux/arch/i386/boot/zImage /etc/zImage;
#
clear;
echo " *** Time to cleanup "
cd /
rm -rf libc-5.4.17.bin.tar.gz
rm -rf binutils-2.7.0.3.bin.tar.gz
rm -rf libg++-2.7.2.1.bin.tar.gz
rm -rf db-1.85.4-bin-ELF.tar.gz
rm -rf linux-2.0.29.tar.gz
rm -rf e2fsprogs-1.06-elfbin.tar.gz
rm -rf make-3.75.tar.gz
rm -rf gcc-2.7.2.1.bin.tar.gz
rm -rf ncurses-1.9.9e.bin.tar.gz
rm -rf ld.so-1.8.5.tar.gz
rm -rf termcap-2.0.8.tar.gz
#
clear;
echo "================================================================================"
echo " *** The New Kernal is in Place *** "
ls -al /etc/zImage;
date;
sleep 5;
echo "================================================================================"
echo " *** Installing The New Kernal for booting *** "
echo "     If you  HAD  (zImage) install in your /etc dir. "
echo "     you will not need to config. your /etc/lilo.conf file. "
echo " "
echo " NOTE: If you do not .. PLEASE run liloconfig or "
echo "       edit the /etc/lilo.conf file, then type.: lilo "
echo "================================================================================"
sleep 20;
lilo;
ldconfig;
echo "================================================================================"
echo " "
echo " *** Done -=- You may re-boot the system at any time *** "
echo " "
echo " *** Thank you for using [Upgrade In A Box] Linux 1.2.X to 2.0.X UPgrade."
echo " -*- by: Jerome G. - New Your City - USA - CND Network."
echo " *** for help / update to this src/program E-mail: jerome@cnd.net "
echo " "
echo "================================================================================"
echo " *** DONE *** "
echo "     NOTE: cd /upgrade-in-a-box   for the backups.."
echo " "
exit 0
