#ifndef _BAD_SECTOR_MAP_H
#define _BAD_SECTOR_MAP_H

/*
 * Copyright (C) 1994-1996 Bas Laarhoven,
 *           (C)      1997 Claus-Justus Heine.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 * $Source: /homes/cvs/ftape/ftape-tools/src/ftformat/ftfmt-bsm.h,v $
 * $Revision: 1.1.1.1 $
 * $Date: 1998/05/07 13:48:18 $
 *
 *      This file contains definitions for the bad sector map handling
 *      routines for the QIC-117 floppy-tape driver for Linux.
 *
 *      This file is a clone of drivers/ftape/ftape-bsm.h
 */

#define EMPTY_SEGMENT           (0xffffffff)

/*  format code 4 bad sector entry, ftape uses this
 *  internally for all format codes
 */
typedef u_int32_t SectorMap;

/* exported functions
 */
void      init_bsm(u_int8_t * buffer, ft_format_type code);
void      put_bsm_entry(int segment_id, SectorMap new_map);
SectorMap get_bsm_entry(int segment_id);

#endif
