dnl       Copyright (C) 1998 Claus-Justus Heine
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2, or (at your option)
dnl any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; see the file COPYING.  If not, write to
dnl the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
dnl
dnl 
dnl $Source: /homes/cvs/ftape/ftape-tools/doc/acinclude.m4,v $
dnl $Revision: 1.3 $
dnl $Date: 1998/08/18 13:35:20 $
dnl
dnl     set prefix to its proper value, so that one can define substitutions
dnl     depending on the value of prefix
dnl
dnl     $Log: acinclude.m4,v $
dnl     Revision 1.3  1998/08/18 13:35:20  claus
dnl     Don't build the Postscript version of the manual by default, require
dnl     the --enable-postscript switch
dnl
dnl     Revision 1.2  1998/08/09 16:11:57  claus
dnl     Create an FTTOOLS_DOC_OPTIONS AC macro which contains all the
dnl     additional automake optinos that doc/configure knows of. Change the
dnl     ACLOCAL variable to "$ACLOCAL -I doc/" to find this macro, and include
dnl     the doc/configure options via a call to the macro into the top level
dnl     configure file, so "configure --help" lists all optoins.
dnl
dnl     Revision 1.1  1998/07/29 08:48:54  claus
dnl     Initial revision
dnl
dnl     Revision 1.1.1.1  1998/07/29 05:47:09  claus
dnl     Imported Sources
dnl

AC_DEFUN(AC_SET_PREFIX,
[test "x$prefix" = xNONE && prefix=$ac_default_prefix
# Let make expand exec_prefix.
test "x$exec_prefix" = xNONE && exec_prefix='${prefix}'
])

AC_DEFUN(FTTOOLS_DOC_OPTIONS,
[
dnl location to install the html documentation in
AC_ARG_WITH(htmldir,
[  --with-htmldir=DIR      where the html documentation should be installed.
                          [PREFIX/share/ftape-tools/html]],
	htmldir=$withval, htmldir=$PKGDATADIR/html)
AC_SUBST(htmldir)

dnl location to install the sgml documentation in
AC_ARG_WITH(sgmldir,
[  --with-sgmldir=DIR      where the sgml documentation should be installed.
                          [PREFIX/share/ftape-tools/sgml]],
	sgmldir=$withval, sgmldir=$PKGDATADIR/sgml)
AC_SUBST(sgmldir)

dnl papersize
AC_ARG_WITH(papersize,
[  --with-papersize=SIZE   paper size to use, SIZE is either a4 or letter
                          [a4]],
	PAPERSIZE=$withval, PAPERSIZE=a4)
AC_SUBST(PAPERSIZE)

dnl info2html server
AC_ARG_WITH(info2html,
[  --with-info2html=URL    info-to-html url to use for "inforef" macros in
                          TeXinfo source code. [http://localhost/cgi-bin/info2html]],
	infoserver=$withval, infoserver='http://localhost/cgi-bin/info2html')
AC_SUBST(infoserver)

dnl LaTeX with postscript fonts.
AC_ARG_WITH(pslatex,
[  --with-pslatex         use postscript fonts for LaTeX. This
                          requires the pslatex package. Only meaningful
                          for the SGML derived formatted documentation [yes]],
	if test x${withval} = xyes; then
		LATEXPATH='$(top_srcdir/etc)'
	else
		LATEXPATH=""
	fi,
	with_pslatex=yes
	LATEXPATH='$(top_srcdir/etc)')
AC_SUBST(LATEXPATH)

dnl install postscript versions of the manaul
AC_ARG_ENABLE(postscript,
[  --enable-postscript     Create and install a Postscript version of
			  the manual as well. Have a good look at the
			  "--with-papersize" option. [disabled]],
	if test x${enableval} = xyes; then
		PS_DOCS=yes
	else		
		PS_DOCS=no
	fi,
	enable_postscript=no
	PS_DOCS=no)
AC_SUBST(PS_DOCS)
AM_CONDITIONAL(PS_DOCS, test x$PS_DOCS = xyes)

dnl Use sgml derived html docs instead of texi2www
AC_ARG_ENABLE(sgml-docs,
[  --enable-sgml-docs      install sgml derived documentation even when
                          the same format can be derived directly from
                          the TeXinfo source code (PS, HTML) [no]],
	SGML_DOCS=${enableval},SGML_DOCS="no")
AC_SUBST(SGML_DOCS)
AM_CONDITIONAL(SGML_DOCS, test x$SGML_DOCS = xyes)
])
