# Read configuration:
source 'config.sh'

# Create qdiscs:
echo Creates qdiscs
WRR_ADDR_FIELD=sour
DEV=$DEV_OUT
BW=$BW_OUT
ADDR=$ADDR_OUT
if [ "$MASQGRADING" = "y" ]; then
  CLASSIFY=masq
else
  CLASSIFY=ip
fi    
source qdisc/create-qdisc.sh

DEV=$DEV_IN
BW=$BW_IN
ADDR=$ADDR_IN
CLASSIFY=ip
WRR_ADDR_FIELD=dest
source qdisc/create-qdisc.sh

# Setup penalty for qdiscs:
echo Sets up penalty
WEIGHT1_DECR=$WEIGHT1_DECR_IN
WEIGHT1_INCR=$WEIGHT1_INCR_IN
WEIGHT1_MIN=$WEIGHT1_MIN_IN
DEV=$DEV_IN
source qdisc/penalty.sh 

WEIGHT1_DECR=$WEIGHT1_DECR_OUT
WEIGHT1_INCR=$WEIGHT1_INCR_OUT
WEIGHT1_MIN=$WEIGHT1_MIN_OUT
DEV=$DEV_OUT
source qdisc/penalty.sh 

# Kill any wipld and wiplc processes running:
echo Kills all instances of wipld and wiplc
killall -q wipld
killall -q wiplc
sleep 1

# Create wipl configuration file and start wipld:
echo Starts wipld
source 'wipl/create-daemon.sh' > $WIPLD_CONF
$PRG_WIPLD -c $WIPLD_CONF
sleep 1

# Create wipl clients:
echo Starts wiplc
source 'wipl/create-clients.sh'

# And start loop:
echo Enters main loop
loop/wrr-loop.sh
