#!/bin/sh

# Delete anything that is setup already
$PRG_TC qdisc del dev $DEV root 2> /dev/null

# Attach cbq to device:
$PRG_TC qdisc add dev $DEV root handle 8000: \
  cbq bandwidth 10Mbit allot 1514 cell 8 avpkt 1514 mpu 64

# Add a high-priority class for forwarded/bridged traffic and attach
# wrr to it:
$PRG_TC class add dev $DEV parent 8000:0 classid 8000:1 \
  cbq bandwidth 10Mbit rate $BW"Kbit" weight 25Kbit allot 1514 cell 8 mpu 64 \
  prio 5 bounded isolated maxburst 10 minburst 0 avpkt 1514   
$PRG_TC filter add dev $DEV parent 8000: protocol ip pref 15 \
   u32 match ip src 0.0.0.0/0 flowid 8000:1
$PRG_TC qdisc add dev $DEV parent 8000:1 handle 8001: \
  wrr $WRR_ADDR_FIELD $CLASSIFY $MAXCLASSES $PROXY_MAXCON pf1=0 pf2=0

# Attach SFQ queus to WRR:
declare -i NUM=$MAXCLASSES;
while [ $NUM -ge 1 ]; do
  HNUM=$(printf %X $NUM)
  $PRG_TC qdisc add dev $DEV parent 8001:$HNUM handle $HNUM: sfq
  NUM=$NUM-1
done  

# If we also have a local address on this interface add this and don't
# shape traffic from that address:
if [ "$ADDR" != "" ]; then
  $PRG_TC class add dev $DEV parent 8000:0 classid 8000:2 \
    cbq bandwidth 10Mbit rate 10Mbit weight 25Kbit allot 1514 cell 8 mpu 64 \
    prio 6 bounded isolated maxburst 10 minburst 0 avpkt 1514
  $PRG_TC filter add dev $DEV parent 8000: protocol ip pref 10 \
    u32 match ip src $ADDR flowid 8000:2
  $PRG_TC qdisc add dev $DEV parent 8000:2 handle 8002: pfifo
fi     
