#!/bin/bash
#
# This is the configuration file for the example WRR setup. Please take you
# time to study it carefully.
#
#  Note:
#    Lan side = where you local machines are = incomming traffic = IN direction
#    Wan side = where you wan link is        = outgoing traffic  = OUT direction
#
#-------------------------------------------------------------------------------------
# Basic setup
#
# Name of network interfaces:
DEV_IN=eth0
DEV_OUT=eth1

# This defines how much bandwidth should be restricted to in Kbit/s for the 
# incoming and outgoing traffic. Refer to the file intro.txt for detailed
# information about setting these parameters.
#
# When the system is running you can execute the script manual-update-speed.sh
# to update the values used to the ones specified here:
BW_IN=1450
BW_OUT=362

# The IP addresses of thus machine should be specified here.
# The machine should always have an address on the LAN side.
# You do not need to specify a WAN address.
ADDR_IN=194.234.39.20
ADDR_OUT=

# If this machine is masqgrading for local machine this should be set to "y", else "n"
MASQGRADING=y

# MAC address of the default gateway used by local machines. That is, the MAC 
# address of DEV_IN if this machine is masqgrading or routing and MAC addresse 
# of the router if this machine is bridgeing:
GATEWAY_MAC=00:60:97:BE:AE:14

# Maximal number of local machines we will ever see. Don't set this too low
# unless you have very sparse memory.
MAXCLASSES=512

# If non-zero proxy remapping is enabled and the number should be the
# maximal number of concurrent connections (it might not work with
# too high values - i have tried 2048 with success)
PROXY_MAXCON=0

#-------------------------------------------------------------------------------------
# Files and directories:

# Programs:
PRG_TC=/usr/local/sbin/tc
PRG_WIPLCEXEC=/usr/local/bin/wiplcExec
PRG_WIPLD=/usr/local/sbin/wipld
PRG_WIPLC=/usr/local/bin/wiplc

# Directory where statistics are be saved:
WIPL_STAT_DIR=/var/www/wipl/

# These are all automatically created:
WIPLD_PIDFILE="/var/run/wipld-in.pid"
WIPLD_CONF="/etc/wrr/wipl/wipld.conf"
WIPLD_LOG="/var/log/wipld-wrr.log"

#------------------------------------------------------------------------------
# Short term penalty setup.
#
# NOTE: In order to not have any short-term penalty simply set
#         WEIGHT1_MIN_OUT=1.0
#         WEIGHT1_MIN_IN =1.0
#
# This is used to setup short-term penalty. A formula for setting useful
# values is given in the wrr.txt document.

WEIGHT1_INCR_IN=0.000833333
WEIGHT1_DECR_IN=0.00000000868
WEIGHT1_MIN_IN=0.5

WEIGHT1_INCR_OUT=0.000833333
WEIGHT1_DECR_OUT=0.0000000347
WEIGHT1_MIN_OUT=0.5
