/*
 * Definitions for a Sony interface CDROM drive.
 *
 * Corey Minyard (minyard@wf-rch.cirr.com)
 *
 *  Copyright (C) 1993  Corey Minyard
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * Offsets (from the base address) and bits for the various write registers
 * of the drive.
 */
#define SONY_CMD_REG_OFFSET	0
#define SONY_PARAM_REG_OFFSET	1
#define SONY_WRITE_REG_OFFSET	2
#define SONY_CONTROL_REG_OFFSET	3
#	define SONY_ATTN_CLR_BIT	0x01
#	define SONY_RES_RDY_CLR_BIT	0x02
#	define SONY_DATA_RDY_CLR_BIT	0x04
#	define SONY_ATTN_INT_EN_BIT	0x08
#	define SONY_RES_RDY_INT_EN_BIT	0x10
#	define SONY_DATA_RDY_INT_EN_BIT	0x20
#	define SONY_PARAM_CLR_BIT	0x40
#	define SONY_DRIVE_RESET_BIT	0x80

/*
 * Offsets (from the base address) and bits for the various read registers
 * of the drive.
 */
#define SONY_STATUS_REG_OFFSET	0
#	define SONY_ATTN_BIT		0x01
#	define SONY_RES_RDY_BIT		0x02
#	define SONY_DATA_RDY_BIT	0x04
#	define SONY_ATTN_INT_ST_BIT	0x08
#	define SONY_RES_RDY_INT_ST_BIT	0x10
#	define SONY_DATA_RDY_INT_ST_BIT	0x20
#	define SONY_DATA_REQUEST_BIT	0x40
#	define SONY_BUSY_BIT		0x80
#define SONY_RESULT_REG_OFFSET	1
#define SONY_READ_REG_OFFSET	2
#define SONY_FIFOST_REG_OFFSET	3
#	define SONY_PARAM_WRITE_RDY_BIT	0x01
#	define SONY_PARAM_REG_EMPTY_BIT	0x02
#	define SONY_RES_REG_NOT_EMP_BIT	0x04
#	define SONY_RES_REG_FULL_BIT	0x08

#define LOG_START_OFFSET	150	/* Offset of first logical sector */

#define SONY_DETECT_TIMEOUT	80	/* Maximum amount of time
					   that drive detection code
					   will wait for response
					   from drive (in 1/100th's
					   of seconds). */
 
#define SONY_JIFFIES_TIMEOUT	500	/* Maximum number of times the
					   drive will wait/try for an
					   operation */
#define SONY_RESET_TIMEOUT	100	/* Maximum number of times the
					   drive will wait/try a reset
					   operation */
#define SONY_READY_RETRIES	20000	/* How many times to retry a
					   spin waiting for a register
					   to come ready */

#define MAX_CDU31A_RETRIES	3	/* How many times to retry an
					   operation */

/* Commands to request or set drive control parameters and disc information */
#define SONY_REQ_DRIVE_CONFIG_CMD	0x00    /* Returns s_sony_drive_config */
#define SONY_REQ_DRIVE_MODE_CMD		0x01
#define SONY_REQ_DRIVE_PARAM_CMD	0x02
#define SONY_REQ_MECH_STATUS_CMD	0x03
#define SONY_REQ_AUDIO_STATUS_CMD	0x04
#define SONY_SET_DRIVE_PARAM_CMD	0x10
#define SONY_REQ_TOC_DATA_CMD		0x20    /* Returns s_sony_toc */
#define SONY_REQ_SUBCODE_ADDRESS_CMD	0x21    /* Returns s_sony_subcode */
#define SONY_REQ_UPC_EAN_CMD		0x22
#define SONY_REQ_ISRC_CMD		0x23
#define SONY_REQ_TOC_DATA_SPEC_CMD	0x24

/* Commands to request information from the drive */
#define SONY_READ_TOC_CMD		0x30
#define SONY_SEEK_CMD			0x31
#define SONY_READ_CMD			0x32
#define SONY_READ_BLKERR_STAT_CMD	0x34
#define SONY_ABORT_CMD			0x35
#define SONY_READ_TOC_SPEC_CMD		0x36

/* Commands to control audio */
#define SONY_AUDIO_PLAYBACK_CMD		0x40
#define SONY_AUDIO_STOP_CMD		0x41
#define SONY_AUDIO_SCAN_CMD		0x42

/* Miscellaneous control commands */
#define SONY_EJECT_CMD			0x50
#define SONY_SPIN_UP_CMD		0x51
#define SONY_SPIN_DOWN_CMD		0x52

/* Diagnostic commands */
#define SONY_WRITE_BUFFER_CMD		0x60
#define SONY_READ_BUFFER_CMD		0x61
#define SONY_DIAGNOSTICS_CMD		0x62


/*
 * The following are command parameters for the set drive parameter command
 */
#define SONY_SD_DECODE_PARAM		0x00
#define SONY_SD_